/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.rewriter;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import owl.ltl.Biconditional;
import owl.ltl.BinaryModalOperator;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.FrequencyG;
import owl.ltl.GOperator;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.PropositionalFormula;
import owl.ltl.ROperator;
import owl.ltl.UOperator;
import owl.ltl.WOperator;
import owl.ltl.XOperator;
import owl.ltl.rewriter.SyntacticFairnessSimplifier;
import owl.ltl.visitors.Visitor;

class SyntacticSimplifier
implements Visitor<Formula>,
UnaryOperator<Formula> {
    static final UnaryOperator<Formula> INSTANCE = new SyntacticSimplifier();

    SyntacticSimplifier() {
    }

    @Override
    public Formula apply(Formula formula) {
        return formula.accept(this);
    }

    @Override
    public Formula visit(Biconditional biconditional) {
        return Biconditional.of(biconditional.left.accept(this), biconditional.right.accept(this));
    }

    @Override
    public Formula visit(BooleanConstant booleanConstant) {
        return booleanConstant;
    }

    @Override
    public Formula visit(Literal literal) {
        return literal;
    }

    @Override
    public Formula visit(FrequencyG freq) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Formula visit(Conjunction conjunction) {
        Set<Formula> newConjunction = conjunction.map(x -> x.accept(this)).collect(Collectors.toSet());
        if (newConjunction.stream().anyMatch(x -> newConjunction.contains(x.not()))) {
            return BooleanConstant.FALSE;
        }
        for (GOperator gOperator : SyntacticSimplifier.filter(newConjunction, GOperator.class)) {
            newConjunction.remove(gOperator.operand);
            if (!newConjunction.contains(gOperator.operand.not())) continue;
            return BooleanConstant.FALSE;
        }
        for (FOperator fOperator : SyntacticSimplifier.filter(newConjunction, FOperator.class)) {
            if (!newConjunction.contains(fOperator.operand)) continue;
            newConjunction.remove(fOperator);
        }
        for (BinaryModalOperator operator : SyntacticSimplifier.filter(newConjunction, BinaryModalOperator.class, x -> x instanceof UOperator || x instanceof WOperator)) {
            if (!newConjunction.contains(operator.right)) continue;
            newConjunction.remove(operator);
        }
        for (BinaryModalOperator operator : SyntacticSimplifier.filter(newConjunction, BinaryModalOperator.class, x -> x instanceof MOperator || x instanceof ROperator)) {
            if (!newConjunction.contains(operator.left)) continue;
            newConjunction.remove(operator);
            newConjunction.add(operator.right);
        }
        for (Disjunction disjunction : SyntacticSimplifier.filter(newConjunction, Disjunction.class)) {
            Formula newDisjunction = Disjunction.of(disjunction.children.stream().filter(x -> !newConjunction.contains(x.not())));
            newConjunction.remove(disjunction);
            newConjunction.add(newDisjunction);
        }
        return Conjunction.of(newConjunction);
    }

    @Override
    public Formula visit(Disjunction disjunction) {
        Set<Formula> newDisjunction = disjunction.map(x -> x.accept(this)).collect(Collectors.toSet());
        if (newDisjunction.stream().anyMatch(x -> newDisjunction.contains(x.not()))) {
            return BooleanConstant.TRUE;
        }
        for (FOperator fOperator : SyntacticSimplifier.filter(newDisjunction, FOperator.class)) {
            newDisjunction.remove(fOperator.operand);
            if (!newDisjunction.contains(fOperator.operand.not())) continue;
            return BooleanConstant.TRUE;
        }
        for (GOperator gOperator : SyntacticSimplifier.filter(newDisjunction, GOperator.class)) {
            if (!newDisjunction.contains(gOperator.operand)) continue;
            newDisjunction.remove(gOperator);
        }
        for (BinaryModalOperator operator : SyntacticSimplifier.filter(newDisjunction, BinaryModalOperator.class, x -> x instanceof MOperator || x instanceof ROperator)) {
            if (!newDisjunction.contains(operator.right)) continue;
            newDisjunction.remove(operator);
        }
        for (BinaryModalOperator operator : SyntacticSimplifier.filter(newDisjunction, BinaryModalOperator.class, x -> x instanceof UOperator || x instanceof WOperator)) {
            if (!newDisjunction.contains(operator.left)) continue;
            newDisjunction.remove(operator);
            newDisjunction.add(operator.right);
        }
        for (Conjunction conjunction : SyntacticSimplifier.filter(newDisjunction, Conjunction.class)) {
            Formula newConjunction = Conjunction.of(conjunction.children.stream().filter(x -> !newDisjunction.contains(x.not())));
            newDisjunction.remove(conjunction);
            newDisjunction.add(newConjunction);
        }
        return Disjunction.of(newDisjunction);
    }

    @Override
    public Formula visit(FOperator fOperator) {
        Formula formula;
        Formula operand = fOperator.operand;
        if (SyntacticFairnessSimplifier.isApplicable2(fOperator)) {
            formula = (Formula)SyntacticFairnessSimplifier.NormaliseX.UNGUARDED_INSTANCE.apply(fOperator);
            assert (formula instanceof FOperator);
            operand = ((FOperator)formula).operand;
        }
        if ((operand = operand.accept(this)).isPureEventual() || operand.isSuspendable()) {
            return operand;
        }
        if (operand instanceof ROperator) {
            ROperator rOperator = (ROperator)operand;
            return Disjunction.of(FOperator.of(Conjunction.of(rOperator.left, rOperator.right)), FOperator.of(GOperator.of(rOperator.right)));
        }
        if (operand instanceof Conjunction) {
            Conjunction conjunction = (Conjunction)operand;
            HashSet<Formula> suspendable = new HashSet<Formula>();
            HashSet others = new HashSet();
            conjunction.forEach(x -> {
                if (x.isSuspendable()) {
                    suspendable.add((Formula)x);
                } else {
                    others.add(x);
                }
            });
            if (!suspendable.isEmpty()) {
                suspendable.add(FOperator.of(Conjunction.of(others)));
                return Conjunction.of(suspendable).accept(this);
            }
            if (others.stream().allMatch(Formula::isPureUniversal)) {
                return Conjunction.of(others.stream().map(FOperator::of)).accept(this);
            }
        }
        if (SyntacticFairnessSimplifier.isApplicable(formula = FOperator.of(operand))) {
            Formula almostAllOperand = SyntacticFairnessSimplifier.getAlmostAllOperand(formula);
            assert (almostAllOperand != null);
            Formula normalisedX = (Formula)SyntacticFairnessSimplifier.NormaliseX.UNGUARDED_INSTANCE.apply(almostAllOperand);
            return normalisedX.accept(SyntacticFairnessSimplifier.ALMOST_ALL_VISITOR);
        }
        return formula;
    }

    @Override
    public Formula visit(GOperator gOperator) {
        Formula formula;
        Formula operand = gOperator.operand;
        if (SyntacticFairnessSimplifier.isApplicable2(gOperator)) {
            formula = (Formula)SyntacticFairnessSimplifier.NormaliseX.UNGUARDED_INSTANCE.apply(gOperator);
            assert (formula instanceof GOperator);
            operand = ((GOperator)formula).operand;
        }
        if ((operand = operand.accept(this)).isPureUniversal() || operand.isSuspendable()) {
            return operand;
        }
        if (operand instanceof UOperator) {
            UOperator uOperator = (UOperator)operand;
            return Conjunction.of(GOperator.of(Disjunction.of(uOperator.left, uOperator.right)), GOperator.of(FOperator.of(uOperator.right)));
        }
        if (operand instanceof Disjunction) {
            Disjunction disjunction = (Disjunction)operand;
            HashSet<Formula> suspendable = new HashSet<Formula>();
            HashSet others = new HashSet();
            disjunction.forEach(x -> {
                if (x.isSuspendable()) {
                    suspendable.add((Formula)x);
                } else {
                    others.add(x);
                }
            });
            if (!suspendable.isEmpty()) {
                suspendable.add(GOperator.of(Disjunction.of(others)));
                return Disjunction.of(suspendable).accept(this);
            }
            if (others.stream().allMatch(Formula::isPureEventual)) {
                return Disjunction.of(others.stream().map(GOperator::of)).accept(this);
            }
        }
        if (SyntacticFairnessSimplifier.isApplicable(formula = GOperator.of(operand))) {
            Formula infinitelyOftenOperand = SyntacticFairnessSimplifier.getInfinitelyOftenOperand(formula);
            assert (infinitelyOftenOperand != null);
            Formula normalisedX = (Formula)SyntacticFairnessSimplifier.NormaliseX.UNGUARDED_INSTANCE.apply(infinitelyOftenOperand);
            return normalisedX.accept(SyntacticFairnessSimplifier.INFINITELY_OFTEN_VISITOR);
        }
        return formula;
    }

    @Override
    public Formula visit(MOperator mOperator) {
        Formula right;
        Formula left = mOperator.left.accept(this);
        if (left.equals((right = mOperator.right.accept(this)).not())) {
            return BooleanConstant.FALSE;
        }
        if (right.isPureUniversal()) {
            return Conjunction.of(FOperator.of(left), right);
        }
        if (left.isPureEventual()) {
            return Conjunction.of(left, right);
        }
        return MOperator.of(left, right);
    }

    @Override
    public Formula visit(ROperator rOperator) {
        Formula right;
        Formula left = rOperator.left.accept(this);
        if (left.equals((right = rOperator.right.accept(this)).not())) {
            return GOperator.of(right);
        }
        if (right.isPureUniversal()) {
            return right;
        }
        if (left.isPureEventual()) {
            return Disjunction.of(Conjunction.of(left, right), GOperator.of(right));
        }
        return ROperator.of(left, right);
    }

    @Override
    public Formula visit(UOperator uOperator) {
        Formula right;
        Formula left = uOperator.left.accept(this);
        if (left.equals((right = uOperator.right.accept(this)).not())) {
            return FOperator.of(right);
        }
        if (right.isPureEventual()) {
            return right;
        }
        if (left.isPureUniversal()) {
            return Conjunction.of(Disjunction.of(left, right), FOperator.of(right));
        }
        return UOperator.of(left, right);
    }

    @Override
    public Formula visit(WOperator wOperator) {
        Formula right;
        Formula left = wOperator.left.accept(this);
        if (left.equals((right = wOperator.right.accept(this)).not())) {
            return BooleanConstant.TRUE;
        }
        if (right.isPureEventual()) {
            return Disjunction.of(GOperator.of(left), right);
        }
        if (left.isPureUniversal()) {
            return Disjunction.of(left, right);
        }
        return WOperator.of(left, right);
    }

    @Override
    public Formula visit(XOperator xOperator) {
        Formula operand = xOperator.operand.accept(this);
        if (operand.isSuspendable()) {
            return operand;
        }
        if (operand instanceof PropositionalFormula) {
            Set suspendable = ((PropositionalFormula)operand).children.stream().filter(Formula::isSuspendable).collect(Collectors.toSet());
            Sets.SetView others = Sets.difference(((PropositionalFormula)operand).children, suspendable);
            if (!suspendable.isEmpty()) {
                if (operand instanceof Conjunction) {
                    return Conjunction.of((Iterable<? extends Formula>)Sets.union(suspendable, Set.of(XOperator.of(Conjunction.of((Iterable<? extends Formula>)others)))));
                }
                assert (operand instanceof Disjunction);
                return Disjunction.of((Iterable<? extends Formula>)Sets.union(suspendable, Set.of(XOperator.of(Disjunction.of((Iterable<? extends Formula>)others)))));
            }
        }
        if (operand == xOperator.operand) {
            return xOperator;
        }
        return XOperator.of(operand);
    }

    private static <T> Set<T> filter(Collection<Formula> collection, Class<T> clazz) {
        return SyntacticSimplifier.filter(collection, clazz, x -> true);
    }

    private static <T> Set<T> filter(Collection<Formula> iterator, Class<T> clazz, Predicate<T> predicate) {
        HashSet operators = new HashSet();
        iterator.forEach(x -> {
            if (clazz.isInstance(x) && predicate.test(x)) {
                operators.add(x);
            }
        });
        return operators;
    }
}

