/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.robust;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;
import owl.ltl.LabelledFormula;
import owl.ltl.robust.LabelledSplit;
import owl.ltl.robust.Split;

@ParametersAreNonnullByDefault
@Generated(from="LabelledSplit", generator="Immutables")
@CheckReturnValue
@Immutable
final class LabelledSplitTuple
extends LabelledSplit {
    private final Split split;
    private final ImmutableList<String> variables;
    private final transient LabelledFormula always;
    private final transient LabelledFormula eventuallyAlways;
    private final transient LabelledFormula infinitelyOften;
    private final transient LabelledFormula eventually;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private LabelledSplitTuple(Split split, Iterable<String> variables) {
        this.split = Objects.requireNonNull(split, "split");
        this.variables = ImmutableList.copyOf(variables);
        this.always = this.initShim.always();
        this.eventuallyAlways = this.initShim.eventuallyAlways();
        this.infinitelyOften = this.initShim.infinitelyOften();
        this.eventually = this.initShim.eventually();
        this.initShim = null;
    }

    @Override
    Split split() {
        return this.split;
    }

    public ImmutableList<String> variables() {
        return this.variables;
    }

    @Override
    public LabelledFormula always() {
        InitShim shim = this.initShim;
        return shim != null ? shim.always() : this.always;
    }

    @Override
    public LabelledFormula eventuallyAlways() {
        InitShim shim = this.initShim;
        return shim != null ? shim.eventuallyAlways() : this.eventuallyAlways;
    }

    @Override
    public LabelledFormula infinitelyOften() {
        InitShim shim = this.initShim;
        return shim != null ? shim.infinitelyOften() : this.infinitelyOften;
    }

    @Override
    public LabelledFormula eventually() {
        InitShim shim = this.initShim;
        return shim != null ? shim.eventually() : this.eventually;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof LabelledSplitTuple && this.equalTo((LabelledSplitTuple)another);
    }

    private boolean equalTo(LabelledSplitTuple another) {
        return this.split.equals(another.split) && this.variables.equals(another.variables) && this.always.equals(another.always) && this.eventuallyAlways.equals(another.eventuallyAlways) && this.infinitelyOften.equals(another.infinitelyOften) && this.eventually.equals(another.eventually);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.split.hashCode();
        h += (h << 5) + this.variables.hashCode();
        h += (h << 5) + this.always.hashCode();
        h += (h << 5) + this.eventuallyAlways.hashCode();
        h += (h << 5) + this.infinitelyOften.hashCode();
        h += (h << 5) + this.eventually.hashCode();
        return h;
    }

    public static LabelledSplitTuple create(Split split, List<String> variables) {
        return LabelledSplitTuple.create(split, variables);
    }

    public static LabelledSplitTuple create(Split split, Iterable<String> variables) {
        return new LabelledSplitTuple(split, variables);
    }

    private final class InitShim {
        private byte alwaysBuildStage = 0;
        private LabelledFormula always;
        private byte eventuallyAlwaysBuildStage = 0;
        private LabelledFormula eventuallyAlways;
        private byte infinitelyOftenBuildStage = 0;
        private LabelledFormula infinitelyOften;
        private byte eventuallyBuildStage = 0;
        private LabelledFormula eventually;

        private InitShim() {
        }

        LabelledFormula always() {
            if (this.alwaysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.alwaysBuildStage == 0) {
                this.alwaysBuildStage = (byte)-1;
                this.always = Objects.requireNonNull(LabelledSplitTuple.super.always(), "always");
                this.alwaysBuildStage = 1;
            }
            return this.always;
        }

        LabelledFormula eventuallyAlways() {
            if (this.eventuallyAlwaysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.eventuallyAlwaysBuildStage == 0) {
                this.eventuallyAlwaysBuildStage = (byte)-1;
                this.eventuallyAlways = Objects.requireNonNull(LabelledSplitTuple.super.eventuallyAlways(), "eventuallyAlways");
                this.eventuallyAlwaysBuildStage = 1;
            }
            return this.eventuallyAlways;
        }

        LabelledFormula infinitelyOften() {
            if (this.infinitelyOftenBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.infinitelyOftenBuildStage == 0) {
                this.infinitelyOftenBuildStage = (byte)-1;
                this.infinitelyOften = Objects.requireNonNull(LabelledSplitTuple.super.infinitelyOften(), "infinitelyOften");
                this.infinitelyOftenBuildStage = 1;
            }
            return this.infinitelyOften;
        }

        LabelledFormula eventually() {
            if (this.eventuallyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.eventuallyBuildStage == 0) {
                this.eventuallyBuildStage = (byte)-1;
                this.eventually = Objects.requireNonNull(LabelledSplitTuple.super.eventually(), "eventually");
                this.eventuallyBuildStage = 1;
            }
            return this.eventually;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.alwaysBuildStage == -1) {
                attributes.add("always");
            }
            if (this.eventuallyAlwaysBuildStage == -1) {
                attributes.add("eventuallyAlways");
            }
            if (this.infinitelyOftenBuildStage == -1) {
                attributes.add("infinitelyOften");
            }
            if (this.eventuallyBuildStage == -1) {
                attributes.add("eventually");
            }
            return "Cannot build LabelledSplit, attribute initializers form cycle " + attributes;
        }
    }
}

