/*
 * Decompiled with CFR 0.152.
 */
package owl.run;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import owl.factories.FactorySupplier;
import owl.run.AbstractDefaultEnvironment;
import owl.run.Environment;

@ParametersAreNonnullByDefault
@Generated(from="AbstractDefaultEnvironment", generator="Immutables")
@CheckReturnValue
@Immutable
public final class DefaultEnvironment
extends AbstractDefaultEnvironment {
    private final boolean annotations;
    private final transient FactorySupplier factorySupplier;
    private final boolean parallel;

    private DefaultEnvironment(boolean annotations, boolean parallel) {
        this.annotations = annotations;
        this.parallel = parallel;
        this.factorySupplier = Objects.requireNonNull(super.factorySupplier(), "factorySupplier");
    }

    @Override
    public boolean annotations() {
        return this.annotations;
    }

    @Override
    public FactorySupplier factorySupplier() {
        return this.factorySupplier;
    }

    @Override
    public boolean parallel() {
        return this.parallel;
    }

    public final DefaultEnvironment withAnnotations(boolean value) {
        if (this.annotations == value) {
            return this;
        }
        return new DefaultEnvironment(value, this.parallel);
    }

    public final DefaultEnvironment withParallel(boolean value) {
        if (this.parallel == value) {
            return this;
        }
        return new DefaultEnvironment(this.annotations, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DefaultEnvironment && this.equalTo((DefaultEnvironment)another);
    }

    private boolean equalTo(DefaultEnvironment another) {
        return this.annotations == another.annotations && this.factorySupplier.equals(another.factorySupplier) && this.parallel == another.parallel;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.annotations);
        h += (h << 5) + this.factorySupplier.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.parallel);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DefaultEnvironment").omitNullValues().add("annotations", this.annotations).add("factorySupplier", (Object)this.factorySupplier).add("parallel", this.parallel).toString();
    }

    public static DefaultEnvironment of(boolean annotations, boolean parallel) {
        return new DefaultEnvironment(annotations, parallel);
    }

    static DefaultEnvironment copyOf(AbstractDefaultEnvironment instance) {
        if (instance instanceof DefaultEnvironment) {
            return (DefaultEnvironment)instance;
        }
        return DefaultEnvironment.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ANNOTATIONS = 1L;
        private static final long INIT_BIT_PARALLEL = 2L;
        private long initBits = 3L;
        private boolean annotations;
        private boolean parallel;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Environment instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(DefaultEnvironment instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AbstractDefaultEnvironment instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Environment instance;
            long bits = 0L;
            if (object instanceof Environment) {
                instance = (Environment)object;
                if ((bits & 1L) == 0L) {
                    this.parallel(instance.parallel());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.annotations(instance.annotations());
                    bits |= 2L;
                }
            }
            if (object instanceof AbstractDefaultEnvironment) {
                instance = (AbstractDefaultEnvironment)object;
                if ((bits & 1L) == 0L) {
                    this.parallel(((AbstractDefaultEnvironment)instance).parallel());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.annotations(((AbstractDefaultEnvironment)instance).annotations());
                    bits |= 2L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder annotations(boolean annotations) {
            this.annotations = annotations;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parallel(boolean parallel) {
            this.parallel = parallel;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public DefaultEnvironment build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new DefaultEnvironment(this.annotations, this.parallel);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("annotations");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("parallel");
            }
            return "Cannot build DefaultEnvironment, some of required attributes are not set " + attributes;
        }
    }
}

