/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.delag;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.BooleanExpression;
import org.apache.commons.cli.Options;
import owl.automaton.Automaton;
import owl.automaton.AutomatonFactory;
import owl.automaton.AutomatonReader;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.edge.Edge;
import owl.factories.Factories;
import owl.ltl.BooleanConstant;
import owl.ltl.LabelledFormula;
import owl.ltl.SyntacticFragment;
import owl.ltl.SyntacticFragments;
import owl.run.Environment;
import owl.run.modules.ImmutableTransformerParser;
import owl.run.modules.InputReaders;
import owl.run.modules.OutputWriters;
import owl.run.modules.OwlModuleParser;
import owl.run.modules.Transformers;
import owl.run.parser.PartialConfigurationParser;
import owl.run.parser.PartialModuleConfiguration;
import owl.translations.ExternalTranslator;
import owl.translations.delag.DependencyTree;
import owl.translations.delag.DependencyTreeFactory;
import owl.translations.delag.History;
import owl.translations.delag.ProductState;
import owl.translations.delag.State;
import owl.translations.ltl2dra.LTL2DRAFunction;

public class DelagBuilder<T>
implements Function<LabelledFormula, Automaton<State<T>, ?>> {
    private static final Function<LabelledFormula, ? extends Automaton<?, ?>> FAIL = formula -> {
        throw new IllegalArgumentException("Not supported: " + formula);
    };
    public static final OwlModuleParser.TransformerParser CLI = ImmutableTransformerParser.builder().key("delag").description("Translates LTL to deterministic Emerson-Lei automata").optionsDirect(new Options().addOption("f", "fallback", true, "Fallback tool for input outside the fragment ('none' for strict mode)")).parser(settings -> environment -> {
        String fallbackTool = settings.getOptionValue("fallback");
        if (fallbackTool == null) {
            return Transformers.instanceFromFunction(LabelledFormula.class, new DelagBuilder(environment));
        }
        ExternalTranslator fallback = "none".equals(fallbackTool) ? FAIL : new ExternalTranslator(environment, fallbackTool);
        return Transformers.instanceFromFunction(LabelledFormula.class, new DelagBuilder<AutomatonReader.HoaState>(environment, fallback));
    }).build();
    private final Environment env;
    private final Function<LabelledFormula, ? extends Automaton<T, ?>> fallback;
    @Nullable
    private LoadingCache<ProductState<T>, History> requiredHistoryCache = null;

    public DelagBuilder(Environment environment) {
        this(environment, new LTL2DRAFunction(environment, EnumSet.of(LTL2DRAFunction.Configuration.OPTIMISE_INITIAL_STATE, LTL2DRAFunction.Configuration.OPTIMISED_STATE_STRUCTURE, LTL2DRAFunction.Configuration.EXISTS_SAFETY_CORE)));
    }

    public DelagBuilder(Environment environment, Function<LabelledFormula, ? extends Automaton<T, ?>> fallback) {
        this.env = environment;
        this.fallback = fallback;
    }

    public static void main(String ... args) {
        PartialConfigurationParser.run(args, PartialModuleConfiguration.builder("delag").reader(InputReaders.LTL).addTransformer(Transformers.LTL_SIMPLIFIER).addTransformer(CLI).writer(OutputWriters.ToHoa.DEFAULT).build());
    }

    @Override
    public Automaton<State<T>, ?> apply(LabelledFormula inputFormula) {
        LabelledFormula formula = SyntacticFragments.normalize(inputFormula, SyntacticFragment.NNF);
        Factories factories = this.env.factorySupplier().getFactories(formula.variables());
        if (formula.formula().equals(BooleanConstant.FALSE)) {
            return AutomatonFactory.empty(factories.vsFactory);
        }
        if (formula.formula().equals(BooleanConstant.TRUE)) {
            return AutomatonFactory.singleton(factories.vsFactory, new State(), AllAcceptance.INSTANCE, Set.of());
        }
        DependencyTreeFactory treeConverter = new DependencyTreeFactory(factories, this.fallback);
        DependencyTree tree = (DependencyTree)formula.accept(treeConverter);
        BooleanExpression<AtomAcceptance> expression = tree.getAcceptanceExpression();
        int sets = treeConverter.setNumber;
        this.requiredHistoryCache = CacheBuilder.newBuilder().maximumSize(1024L).build(CacheLoader.from(key -> History.create(tree.getRequiredHistory(key))));
        ProductState initialProduct = treeConverter.buildInitialState();
        State initialState = new State(initialProduct, this.getHistory(null, new BitSet(), initialProduct));
        EmersonLeiAcceptance acceptance = new EmersonLeiAcceptance(sets, expression);
        return AutomatonFactory.create(factories.vsFactory, initialState, acceptance, (x, y) -> this.getSuccessor(tree, (State<T>)x, (BitSet)y));
    }

    private History getHistory(@Nullable History past, BitSet present, ProductState<T> state) {
        assert (this.requiredHistoryCache != null);
        History requiredHistory = (History)this.requiredHistoryCache.getUnchecked(state);
        return History.stepHistory(past, present, requiredHistory);
    }

    @Nullable
    private Edge<State<T>> getSuccessor(DependencyTree<T> tree, State<T> state, BitSet valuation) {
        ProductState.Builder builder = ProductState.builder();
        Boolean acc = tree.buildSuccessor(state, valuation, builder);
        if (acc != null && !acc.booleanValue()) {
            return null;
        }
        ProductState successor = builder.build();
        History history = this.getHistory(state.past, valuation, successor);
        return Edge.of(new State(successor, history), tree.getAcceptance(state, valuation, acc));
    }
}

