/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2ldba;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import owl.factories.EquivalenceClassFactory;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.ltl.SyntacticFragment;
import owl.ltl.visitors.PropositionalVisitor;
import owl.translations.ltl2ldba.AnalysisResult;
import owl.translations.ltl2ldba.Jump;
import owl.translations.ltl2ldba.LTL2LDBAFunction;
import owl.translations.ltl2ldba.RecurringObligation;

public abstract class AbstractJumpManager<X extends RecurringObligation> {
    private static final Logger logger = Logger.getLogger(AbstractJumpManager.class.getName());
    private static final AnalysisResult<?> EMPTY = AnalysisResult.buildMay(Set.of());
    protected final EquivalenceClassFactory factory;
    protected final Set<LTL2LDBAFunction.Configuration> configuration;
    protected final Set<Formula> blockingModalOperators;

    protected AbstractJumpManager(Set<LTL2LDBAFunction.Configuration> configuration, EquivalenceClassFactory factory, Set<Formula> modalOperators, Formula initialFormula) {
        this.configuration = Set.copyOf(configuration);
        this.factory = factory;
        Set<Formula> unfilteredBlockingModalOperators = initialFormula.accept(BlockingModalOperatorsVisitor.INSTANCE);
        this.blockingModalOperators = unfilteredBlockingModalOperators.stream().filter(x -> !AbstractJumpManager.isProperSubformula(x, modalOperators)).collect(Collectors.toUnmodifiableSet());
    }

    protected static <X> Stream<X> createDisjunctionStream(EquivalenceClass state, Function<Formula, Stream<X>> streamBuilder) {
        Formula representative = state.representative();
        if (!(representative instanceof Disjunction)) {
            return streamBuilder.apply(state.representative());
        }
        Disjunction disjunction = (Disjunction)representative;
        Stream stream = Stream.empty();
        for (Formula disjunct : disjunction.children) {
            EquivalenceClass disjunctState = state.factory().of(disjunct);
            stream = Stream.concat(stream, streamBuilder.apply(disjunctState.representative()));
        }
        return stream;
    }

    AnalysisResult<X> analyse(EquivalenceClass state) {
        AnalysisResult<X> result = this.checkTrivial(state);
        if (result != null) {
            return result;
        }
        Set jumps = this.computeJumps(state);
        logger.log(Level.FINE, () -> state + " has the following jumps: " + jumps);
        if (this.configuration.contains((Object)LTL2LDBAFunction.Configuration.SUPPRESS_JUMPS)) {
            jumps.removeIf(jump -> jumps.stream().anyMatch(otherJump -> jump != otherJump && otherJump.containsLanguageOf(jump)));
        }
        logger.log(Level.FINE, () -> state + " has the following jumps (after language inclusion check): " + jumps);
        if (this.configuration.contains((Object)LTL2LDBAFunction.Configuration.FORCE_JUMPS)) {
            for (Jump<X> jump2 : jumps) {
                EquivalenceClass jumpLanguage = jump2.getLanguage();
                if (this.configuration.contains((Object)LTL2LDBAFunction.Configuration.EAGER_UNFOLD)) {
                    jumpLanguage = jumpLanguage.unfold();
                }
                if (!state.equals(jumpLanguage)) continue;
                return AnalysisResult.buildMust(jump2);
            }
        }
        return AnalysisResult.buildMay(jumps);
    }

    protected Jump<X> buildJump(EquivalenceClass remainder, X obligations) {
        if (this.configuration.contains((Object)LTL2LDBAFunction.Configuration.EAGER_UNFOLD)) {
            return new Jump<X>(remainder.unfold(), obligations);
        }
        return new Jump<X>(remainder, obligations);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private AnalysisResult<X> checkTrivial(EquivalenceClass state) {
        block3: {
            block2: {
                Set<Formula> modalOperators = state.modalOperators();
                if (modalOperators.stream().allMatch(SyntacticFragment.CO_SAFETY::contains)) break block2;
                if (!modalOperators.stream().allMatch(SyntacticFragment.SAFETY::contains)) break block3;
            }
            logger.log(Level.FINE, () -> state + " is (co)safety. Suppressing jump.");
            return EMPTY;
        }
        if (!this.configuration.contains((Object)LTL2LDBAFunction.Configuration.SUPPRESS_JUMPS)) return null;
        if (!state.modalOperators().stream().anyMatch(this.blockingModalOperators::contains)) return null;
        AnalysisResult<?> analysisResult = EMPTY;
        return analysisResult;
    }

    protected abstract Set<Jump<X>> computeJumps(EquivalenceClass var1);

    private static boolean isProperSubformula(Formula formula, Collection<? extends Formula> set) {
        return set.stream().anyMatch(x -> {
            if (x.equals(formula)) return false;
            if (!x.anyMatch(formula::equals)) return false;
            return true;
        });
    }

    static class BlockingModalOperatorsVisitor
    extends PropositionalVisitor<Set<Formula>> {
        static final BlockingModalOperatorsVisitor INSTANCE = new BlockingModalOperatorsVisitor();

        BlockingModalOperatorsVisitor() {
        }

        @Override
        protected Set<Formula> modalOperatorAction(Formula formula) {
            if (SyntacticFragment.FINITE.contains(formula)) {
                return Set.of();
            }
            if (SyntacticFragment.CO_SAFETY.contains(formula)) {
                return Set.of(formula);
            }
            return Set.of();
        }

        @Override
        public Set<Formula> visit(BooleanConstant booleanConstant) {
            return Set.of();
        }

        @Override
        public Set<Formula> visit(Conjunction conjunction) {
            HashSet<Formula> blockingOperators = new HashSet<Formula>();
            for (Formula child : conjunction.children) {
                if (SyntacticFragment.FINITE.contains(child)) continue;
                blockingOperators.addAll((Collection<Formula>)child.accept(this));
            }
            return blockingOperators;
        }

        @Override
        public Set<Formula> visit(Disjunction disjunction) {
            HashSet blockingOperators = null;
            for (Formula child : disjunction.children) {
                if (SyntacticFragment.FINITE.contains(child)) continue;
                if (blockingOperators == null) {
                    blockingOperators = new HashSet(child.accept(this));
                    continue;
                }
                blockingOperators.retainAll((Collection)child.accept(this));
            }
            return blockingOperators == null ? Set.of() : blockingOperators;
        }
    }
}

