/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2ldba;

import com.google.common.collect.Iterables;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import owl.automaton.MutableAutomaton;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.ldba.LimitDeterministicAutomaton;
import owl.automaton.ldba.LimitDeterministicAutomatonBuilder;
import owl.automaton.ldba.MutableAutomatonBuilder;
import owl.factories.EquivalenceClassFactory;
import owl.factories.Factories;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.SyntacticFragment;
import owl.ltl.SyntacticFragments;
import owl.run.Environment;
import owl.translations.ltl2ldba.AbstractJumpManager;
import owl.translations.ltl2ldba.AnalysisResult;
import owl.translations.ltl2ldba.EquivalenceClassStateFactory;
import owl.translations.ltl2ldba.InitialComponentBuilder;
import owl.translations.ltl2ldba.Jump;
import owl.translations.ltl2ldba.RecurringObligation;
import owl.translations.ltl2ldba.SafetyDetector;
import owl.translations.ltl2ldba.breakpoint.DegeneralizedBreakpointState;
import owl.translations.ltl2ldba.breakpoint.GObligations;
import owl.translations.ltl2ldba.breakpoint.GObligationsJumpManager;
import owl.translations.ltl2ldba.breakpoint.GeneralizedBreakpointState;
import owl.translations.ltl2ldba.breakpointfree.DegeneralizedAcceptingComponentBuilder;
import owl.translations.ltl2ldba.breakpointfree.DegeneralizedBreakpointFreeState;
import owl.translations.ltl2ldba.breakpointfree.FGObligations;
import owl.translations.ltl2ldba.breakpointfree.FGObligationsJumpManager;
import owl.translations.ltl2ldba.breakpointfree.GeneralizedAcceptingComponentBuilder;
import owl.translations.ltl2ldba.breakpointfree.GeneralizedBreakpointFreeState;

public final class LTL2LDBAFunction<S, B extends GeneralizedBuchiAcceptance, C extends RecurringObligation>
implements Function<LabelledFormula, LimitDeterministicAutomaton<EquivalenceClass, S, B, C>> {
    private final Function<Factories, MutableAutomatonBuilder<Jump<C>, S, B>> builderConstructor;
    private final Environment env;
    private final Function<S, C> getAnnotation;
    private final Set<Configuration> configuration;
    private final BiFunction<Formula, EquivalenceClassFactory, AbstractJumpManager<C>> selectorConstructor;

    private LTL2LDBAFunction(Environment env, BiFunction<Formula, EquivalenceClassFactory, AbstractJumpManager<C>> selectorConstructor, Function<Factories, MutableAutomatonBuilder<Jump<C>, S, B>> builderConstructor, Set<Configuration> configuration, Function<S, C> getAnnotation) {
        this.env = env;
        this.selectorConstructor = selectorConstructor;
        this.builderConstructor = builderConstructor;
        this.configuration = configuration;
        this.getAnnotation = getAnnotation;
    }

    public static Function<LabelledFormula, LimitDeterministicAutomaton<EquivalenceClass, DegeneralizedBreakpointFreeState, BuchiAcceptance, FGObligations>> createDegeneralizedBreakpointFreeLDBABuilder(Environment env, Set<Configuration> configuration) {
        Set<Configuration> configuration2 = Set.copyOf(configuration);
        return new LTL2LDBAFunction<DegeneralizedBreakpointFreeState, BuchiAcceptance, FGObligations>(env, (x, y) -> FGObligationsJumpManager.build(x, y, configuration2), x -> new DegeneralizedAcceptingComponentBuilder((Factories)x, configuration2), configuration2, DegeneralizedBreakpointFreeState::getObligations);
    }

    public static Function<LabelledFormula, LimitDeterministicAutomaton<EquivalenceClass, DegeneralizedBreakpointState, BuchiAcceptance, GObligations>> createDegeneralizedBreakpointLDBABuilder(Environment env, Set<Configuration> configuration) {
        Set<Configuration> configuration2 = Set.copyOf(configuration);
        return new LTL2LDBAFunction<DegeneralizedBreakpointState, BuchiAcceptance, GObligations>(env, (x, y) -> GObligationsJumpManager.build(x, y, configuration2), x -> new owl.translations.ltl2ldba.breakpoint.DegeneralizedAcceptingComponentBuilder((Factories)x, configuration2), configuration2, DegeneralizedBreakpointState::getObligations);
    }

    public static Function<LabelledFormula, LimitDeterministicAutomaton<EquivalenceClass, GeneralizedBreakpointFreeState, GeneralizedBuchiAcceptance, FGObligations>> createGeneralizedBreakpointFreeLDBABuilder(Environment env, Set<Configuration> configuration) {
        Set<Configuration> configuration2 = Set.copyOf(configuration);
        return new LTL2LDBAFunction<GeneralizedBreakpointFreeState, GeneralizedBuchiAcceptance, FGObligations>(env, (x, y) -> FGObligationsJumpManager.build(x, y, configuration2), x -> new GeneralizedAcceptingComponentBuilder((Factories)x, configuration2), configuration2, GeneralizedBreakpointFreeState::getObligations);
    }

    public static Function<LabelledFormula, LimitDeterministicAutomaton<EquivalenceClass, GeneralizedBreakpointState, GeneralizedBuchiAcceptance, GObligations>> createGeneralizedBreakpointLDBABuilder(Environment env, Set<Configuration> configuration) {
        Set<Configuration> configuration2 = Set.copyOf(configuration);
        return new LTL2LDBAFunction<GeneralizedBreakpointState, GeneralizedBuchiAcceptance, GObligations>(env, (x, y) -> GObligationsJumpManager.build(x, y, configuration2), x -> new owl.translations.ltl2ldba.breakpoint.GeneralizedAcceptingComponentBuilder((Factories)x, configuration2), configuration2, GeneralizedBreakpointState::getObligations);
    }

    @Override
    public LimitDeterministicAutomaton<EquivalenceClass, S, B, C> apply(LabelledFormula input) {
        LabelledFormula formula = SyntacticFragments.normalize(input, SyntacticFragment.NNF);
        Factories factories = this.env.factorySupplier().getFactories(formula.variables(), true);
        AbstractJumpManager<C> jumpManager = this.selectorConstructor.apply(formula.formula(), factories.eqFactory);
        InitialComponentBuilder<C> initialComponentBuilder = new InitialComponentBuilder<C>(factories, this.configuration, jumpManager);
        MutableAutomatonBuilder<Jump<C>, S, B> acceptingComponentBuilder = this.builderConstructor.apply(factories);
        LimitDeterministicAutomatonBuilder<EquivalenceClass, Jump<C>, Object, B, C> result = this.configuration.contains((Object)Configuration.EPSILON_TRANSITIONS) ? LimitDeterministicAutomatonBuilder.create(initialComponentBuilder::build, acceptingComponentBuilder, initialComponentBuilder::getJumps, this.getAnnotation, EnumSet.of(LimitDeterministicAutomatonBuilder.Configuration.SUPPRESS_JUMPS_FOR_TRANSIENT_STATES), x1 -> SafetyDetector.hasSafetyCore(x1, false)) : LimitDeterministicAutomatonBuilder.create(initialComponentBuilder::build, acceptingComponentBuilder, initialComponentBuilder::getJumps, this.getAnnotation, EnumSet.of(LimitDeterministicAutomatonBuilder.Configuration.REMOVE_EPSILON_TRANSITIONS, LimitDeterministicAutomatonBuilder.Configuration.SUPPRESS_JUMPS_FOR_TRANSIENT_STATES), x1 -> SafetyDetector.hasSafetyCore(x1, false));
        LimitDeterministicAutomatonBuilder<EquivalenceClass, Jump<C>, S, B, C> builder = result;
        for (EquivalenceClass initialClass : this.createInitialClasses(factories, formula.formula())) {
            AnalysisResult<C> obligations = jumpManager.analyse(initialClass);
            if (obligations.type == AnalysisResult.TYPE.MUST) {
                builder.addInitialStateAcceptingComponent((Jump)Iterables.getOnlyElement(obligations.jumps));
                continue;
            }
            initialComponentBuilder.add(initialClass);
        }
        LimitDeterministicAutomaton<EquivalenceClass, S, B, C> ldba = builder.build();
        BitSet bitSet = new BitSet();
        bitSet.set(0, ((GeneralizedBuchiAcceptance)ldba.acceptingComponent().acceptance()).size);
        MutableAutomaton initialComponent = (MutableAutomaton)ldba.initialComponent();
        initialComponent.updateEdges((state, x) -> {
            assert (!state.isFalse());
            return SafetyDetector.hasSafetyCore(state, false) ? x.withAcceptance(bitSet) : x;
        });
        initialComponent.trim();
        return ldba;
    }

    private Iterable<EquivalenceClass> createInitialClasses(Factories factories, Formula formula) {
        EquivalenceClassStateFactory factory = new EquivalenceClassStateFactory(factories, this.configuration);
        if (this.configuration.contains((Object)Configuration.NON_DETERMINISTIC_INITIAL_COMPONENT)) {
            EquivalenceClass clazz = factories.eqFactory.of(formula);
            return factory.splitEquivalenceClass(clazz);
        }
        return Set.of(factory.getInitial(formula));
    }

    public static enum Configuration {
        NON_DETERMINISTIC_INITIAL_COMPONENT,
        EAGER_UNFOLD,
        FORCE_JUMPS,
        OPTIMISED_STATE_STRUCTURE,
        SUPPRESS_JUMPS,
        EPSILON_TRANSITIONS;

    }
}

