/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2ldba.breakpoint;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.immutables.value.Value;
import owl.factories.EquivalenceClassFactory;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.SyntacticFragment;
import owl.translations.ltl2ldba.FGSubstitution;
import owl.translations.ltl2ldba.LTL2LDBAFunction;
import owl.translations.ltl2ldba.RecurringObligation;
import owl.translations.ltl2ldba.breakpoint.GObligationsTuple;
import owl.util.annotation.HashedTuple;

@Value.Immutable
@HashedTuple
public abstract class GObligations
implements RecurringObligation {
    abstract Set<GOperator> gOperators();

    abstract Set<GOperator> gOperatorsRewritten();

    abstract List<EquivalenceClass> liveness();

    abstract List<EquivalenceClass> obligations();

    abstract EquivalenceClass safety();

    @Nullable
    static GObligations build(Set<GOperator> gOperators, EquivalenceClassFactory factory, Set<LTL2LDBAFunction.Configuration> optimisations) {
        FGSubstitution evaluateVisitor = new FGSubstitution((Iterable<? extends Formula>)gOperators);
        HashSet<GOperator> gOperatorsRewritten = new HashSet<GOperator>();
        EquivalenceClass safety = factory.getTrue();
        ArrayList<EquivalenceClass> liveness = new ArrayList<EquivalenceClass>(gOperators.size());
        ArrayList<EquivalenceClass> obligations = new ArrayList<EquivalenceClass>(gOperators.size());
        for (GOperator gOperator : gOperators) {
            EquivalenceClass clazz;
            Formula formula = gOperator.operand.accept(evaluateVisitor);
            if (!(formula instanceof BooleanConstant) && !(formula instanceof GOperator)) {
                gOperatorsRewritten.add(new GOperator(formula));
            }
            if ((clazz = factory.of(formula)).isFalse()) {
                return null;
            }
            if (optimisations.contains((Object)LTL2LDBAFunction.Configuration.OPTIMISED_STATE_STRUCTURE)) {
                Set<Formula> modalOperators = clazz.modalOperators();
                if (modalOperators.stream().allMatch(SyntacticFragment.SAFETY::contains)) {
                    if (!(safety = safety.and(clazz)).isFalse()) continue;
                    return null;
                }
                if (clazz.atomicPropositions().isEmpty() && modalOperators.stream().allMatch(Formula::isPureEventual)) {
                    liveness.add(clazz);
                    continue;
                }
            }
            obligations.add(clazz);
        }
        if (safety.isTrue() && liveness.isEmpty() && obligations.isEmpty()) {
            return null;
        }
        return GObligationsTuple.create(Set.copyOf(gOperators), Set.copyOf(gOperatorsRewritten), liveness, obligations, safety);
    }

    @Override
    public boolean containsLanguageOf(RecurringObligation other) {
        Preconditions.checkArgument((boolean)(other instanceof GObligations));
        return ((GObligations)other).gOperatorsRewritten().containsAll(this.gOperatorsRewritten()) || ((GObligations)other).getObligation().implies(this.getObligation());
    }

    void forEach(Consumer<EquivalenceClass> consumer) {
        consumer.accept(this.safety());
        for (EquivalenceClass clazz : this.liveness()) {
            consumer.accept(clazz);
        }
        for (EquivalenceClass clazz : this.obligations()) {
            consumer.accept(clazz);
        }
    }

    @Override
    public EquivalenceClass getLanguage() {
        return this.safety().factory().of(Conjunction.of(this.gOperatorsRewritten()));
    }

    EquivalenceClass getObligation() {
        EquivalenceClass obligation = this.safety();
        for (EquivalenceClass clazz : this.liveness()) {
            obligation = obligation.and(clazz);
        }
        for (EquivalenceClass clazz : this.obligations()) {
            obligation = obligation.and(clazz);
        }
        return obligation;
    }

    public String toString() {
        return "<" + (String)(this.safety().isTrue() ? "" : "S=" + this.safety() + " ") + (String)(this.liveness().isEmpty() ? "" : "L=" + this.liveness() + " ") + (String)(this.obligations().isEmpty() ? "" : "O=" + this.obligations()) + ">";
    }
}

