/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance.optimizations;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.BitSet;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.function.IntUnaryOperator;
import owl.automaton.MutableAutomaton;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.acceptance.optimizations.OmegaAcceptanceOptimizations;
import owl.automaton.algorithms.SccDecomposition;
import owl.automaton.edge.Edge;

public final class ParityAcceptanceOptimizations {
    private ParityAcceptanceOptimizations() {
    }

    public static <S> MutableAutomaton<S, ParityAcceptance> minimizePriorities(MutableAutomaton<S, ParityAcceptance> automaton) {
        OmegaAcceptanceOptimizations.removeTransientAcceptance(automaton);
        return ParityAcceptanceOptimizations.minimizePriorities(automaton, SccDecomposition.computeSccs(automaton, false));
    }

    private static <S> MutableAutomaton<S, ParityAcceptance> minimizePriorities(MutableAutomaton<S, ParityAcceptance> automaton, List<Set<S>> sccs) {
        ParityAcceptance acceptance = (ParityAcceptance)automaton.acceptance();
        int acceptanceSets = acceptance.acceptanceSets();
        BitSet globallyUsedPriorities = new BitSet(acceptanceSets);
        Int2IntOpenHashMap reductionMapping = new Int2IntOpenHashMap();
        reductionMapping.defaultReturnValue(-1);
        BitSet usedPriorities = new BitSet(acceptanceSets);
        int usedAcceptanceSets = 0;
        for (Set<S> scc : sccs) {
            reductionMapping.clear();
            usedPriorities.clear();
            for (S state : scc) {
                for (Edge<S> edge : automaton.edges(state)) {
                    PrimitiveIterator.OfInt acceptanceSetIterator;
                    if (!scc.contains(edge.successor()) || !(acceptanceSetIterator = edge.acceptanceSetIterator()).hasNext()) continue;
                    usedPriorities.set(acceptanceSetIterator.nextInt());
                }
            }
            if (usedPriorities.cardinality() == acceptanceSets) {
                usedAcceptanceSets = Math.max(usedAcceptanceSets, acceptanceSets);
                continue;
            }
            int currentPriority = usedPriorities.nextSetBit(0);
            int currentTarget = currentPriority % 2;
            while (currentPriority != -1) {
                if (currentTarget % 2 != currentPriority % 2) {
                    ++currentTarget;
                }
                reductionMapping.put(currentPriority, currentTarget);
                globallyUsedPriorities.set(currentTarget);
                usedAcceptanceSets = Math.max(usedAcceptanceSets, currentTarget + 1);
                currentPriority = usedPriorities.nextSetBit(currentPriority + 1);
            }
            automaton.updateEdges(scc, (arg_0, arg_1) -> ParityAcceptanceOptimizations.lambda$minimizePriorities$0((Int2IntMap)reductionMapping, arg_0, arg_1));
            automaton.trim();
        }
        automaton.acceptance(acceptance.withAcceptanceSets(usedAcceptanceSets));
        return automaton;
    }

    private static /* synthetic */ Edge lambda$minimizePriorities$0(Int2IntMap reductionMapping, Object state, Edge edge) {
        return edge.withAcceptance((IntUnaryOperator)reductionMapping);
    }
}

