/*
 * Decompiled with CFR 0.152.
 */
package owl.collections;

import com.google.auto.value.AutoOneOf;
import java.util.function.Function;
import owl.collections.AutoOneOf_Either;

@AutoOneOf(value=Type.class)
public abstract class Either<A, B> {
    Either() {
    }

    public abstract Type type();

    public abstract A left();

    public abstract B right();

    public static <A, B> Either<A, B> left(A value) {
        return AutoOneOf_Either.left(value);
    }

    public static <A, B> Either<A, B> right(B value) {
        return AutoOneOf_Either.right(value);
    }

    public final <C> C map(Function<? super A, ? extends C> left, Function<? super B, ? extends C> right) {
        switch (this.type()) {
            case LEFT: {
                return left.apply(this.left());
            }
            case RIGHT: {
                return right.apply(this.right());
            }
        }
        throw new AssertionError((Object)"Unreachable.");
    }

    public final String toString() {
        return this.map(a -> "A[" + a + "]", b -> "B[" + b + "]");
    }

    public static enum Type {
        LEFT,
        RIGHT;

    }
}

