/*
 * Decompiled with CFR 0.152.
 */
package owl.game;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.ToIntFunction;
import owl.automaton.AnnotatedState;
import owl.automaton.Automaton;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.edge.Edge;
import owl.game.AutoValue_GameUtil_PriorityState;
import owl.game.Game;
import owl.run.modules.OwlModule;

public final class GameUtil {
    public static final OwlModule<OwlModule.OutputWriter> PG_SOLVER_OUTPUT_MODULE = OwlModule.of("pg-solver", "Writes the given max even parity game in PG Solver format", (commandLine, environment) -> (writer, input) -> {
        PrintWriter printStream = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer, true);
        Preconditions.checkArgument((boolean)(input instanceof Game));
        Game game = (Game)input;
        Preconditions.checkArgument((boolean)(game.acceptance() instanceof ParityAcceptance));
        ParityAcceptance acceptance = (ParityAcceptance)game.acceptance();
        Preconditions.checkArgument((acceptance.parity() == ParityAcceptance.Parity.MAX_EVEN ? 1 : 0) != 0);
        GameUtil.toPgSolver(game, printStream, environment.annotations());
    });

    private GameUtil() {
    }

    public static <S> void toPgSolver(Game<S, ParityAcceptance> game, PrintWriter output, boolean names) {
        assert (game.is(Automaton.Property.COMPLETE));
        ParityAcceptance acceptance = (ParityAcceptance)game.acceptance();
        Preconditions.checkArgument((acceptance.parity() == ParityAcceptance.Parity.MAX_EVEN ? 1 : 0) != 0, (Object)"Invalid acceptance");
        Preconditions.checkArgument((game.initialStates().size() == 1 ? 1 : 0) != 0, (Object)"Multiple initial states not supported");
        Object2IntLinkedOpenHashMap stateNumbering = new Object2IntLinkedOpenHashMap();
        stateNumbering.defaultReturnValue(-1);
        int highestPriority = acceptance.acceptanceSets() - 1;
        Object initialState = game.onlyInitialState();
        stateNumbering.put(PriorityState.of(initialState, highestPriority), 0);
        HashSet reachedStates = new HashSet(List.of(initialState));
        ArrayDeque workQueue = new ArrayDeque(reachedStates);
        ToIntFunction<Edge> getAcceptance = edge -> edge.hasAcceptanceSets() ? edge.smallestAcceptanceSet() + 1 : 0;
        while (!workQueue.isEmpty()) {
            Object state = workQueue.poll();
            Set edges = game.edges(state);
            Preconditions.checkArgument((!edges.isEmpty() ? 1 : 0) != 0, (Object)"Provided game is not complete");
            for (Edge edge2 : edges) {
                assert (acceptance.isWellFormedEdge(edge2));
                Object successor = edge2.successor();
                int stateAcceptance = getAcceptance.applyAsInt(edge2);
                PriorityState prioritySuccessor = PriorityState.of(successor, stateAcceptance);
                stateNumbering.putIfAbsent(prioritySuccessor, stateNumbering.size());
                if (!reachedStates.add(successor)) continue;
                workQueue.add(successor);
            }
        }
        int stateCount = stateNumbering.size();
        output.print("parity ");
        output.print(stateCount);
        output.println(";");
        stateNumbering.forEach((arg_0, arg_1) -> GameUtil.lambda$toPgSolver$3(output, game, acceptance, getAcceptance, (Object2IntMap)stateNumbering, names, arg_0, arg_1));
        output.flush();
    }

    private static /* synthetic */ void lambda$toPgSolver$3(PrintWriter output, Game game, ParityAcceptance acceptance, ToIntFunction getAcceptance, Object2IntMap stateNumbering, boolean names, PriorityState priorityState, Integer identifier) {
        output.print(identifier);
        output.print(' ');
        output.print(priorityState.acceptance());
        output.print(' ');
        output.print(game.owner(priorityState.state()) == Game.Owner.PLAYER_1 ? 0 : 1);
        Iterator iterator = game.edges(priorityState.state()).iterator();
        if (iterator.hasNext()) {
            output.print(' ');
            boolean first = true;
            IntOpenHashSet printedIndices = new IntOpenHashSet();
            while (iterator.hasNext()) {
                int stateAcceptance;
                Edge edge = iterator.next();
                assert (acceptance.isWellFormedEdge(edge));
                Object successor = edge.successor();
                int successorIndex = stateNumbering.getInt(PriorityState.of(successor, stateAcceptance = getAcceptance.applyAsInt(edge)));
                if (!printedIndices.add(successorIndex)) continue;
                assert (successorIndex >= 0);
                if (!first) {
                    output.print(',');
                }
                first = false;
                output.print(successorIndex);
            }
        }
        if (names) {
            output.print(" \"");
            output.print(priorityState.state());
            output.print(" (");
            output.print(priorityState.acceptance());
            output.print(")\"");
        }
        output.println(';');
    }

    @AutoValue
    static abstract class PriorityState<S>
    implements AnnotatedState<S> {
        PriorityState() {
        }

        @Override
        public abstract S state();

        abstract int acceptance();

        static <S> PriorityState<S> of(S state, int acceptance) {
            return new AutoValue_GameUtil_PriorityState<S>(state, acceptance);
        }
    }
}

