/*
 * Decompiled with CFR 0.152.
 */
package owl.factories.jbdd;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import de.tum.in.jbdd.Bdd;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import owl.collections.Collections3;
import owl.collections.ValuationTree;
import owl.factories.EquivalenceClassFactory;
import owl.factories.jbdd.GcManagedFactory;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.ltl.Literal;
import owl.ltl.visitors.PrintVisitor;
import owl.ltl.visitors.PropositionalIntVisitor;

final class EquivalenceFactory
extends GcManagedFactory<BddEquivalenceClass>
implements EquivalenceClassFactory {
    private final List<String> atomicPropositions;
    private final BddVisitor visitor;
    private Formula.TemporalOperator[] reverseMapping;
    private final Map<Formula.TemporalOperator, Integer> mapping;
    private final int trueNode;
    private final int falseNode;
    @Nullable
    private Function<EquivalenceClass, Set<?>> temporalStepTreeCachedMapper;
    @Nullable
    private IdentityHashMap<EquivalenceClass, ValuationTree<?>> temporalStepTreeCache;

    EquivalenceFactory(Bdd bdd, List<String> atomicPropositions) {
        super(bdd);
        this.atomicPropositions = List.copyOf(atomicPropositions);
        int apSize = this.atomicPropositions.size();
        this.mapping = new HashMap<Formula.TemporalOperator, Integer>();
        this.reverseMapping = new Formula.TemporalOperator[apSize];
        this.visitor = new BddVisitor();
        for (int i = 0; i < apSize; ++i) {
            int node = this.bdd.createVariable();
            assert (this.bdd.variable(node) == i);
        }
        this.trueNode = this.bdd.trueNode();
        this.falseNode = this.bdd.falseNode();
    }

    @Override
    public List<String> atomicPropositions() {
        return this.atomicPropositions;
    }

    @Override
    public EquivalenceClass of(Formula formula) {
        return this.of(formula, true);
    }

    private BddEquivalenceClass of(Formula formula, boolean scanForUnknown) {
        List newPropositions;
        if (scanForUnknown && !(newPropositions = formula.subformulas(Formula.TemporalOperator.class).stream().filter(x -> !this.mapping.containsKey(x)).sorted().collect(Collectors.toList())).isEmpty()) {
            int literalOffset = this.atomicPropositions.size();
            int newSize = this.mapping.size() + newPropositions.size();
            this.reverseMapping = Arrays.copyOf(this.reverseMapping, newSize);
            for (Formula.TemporalOperator proposition : newPropositions) {
                int variable = this.bdd.variable(this.bdd.createVariable());
                this.mapping.put(proposition, variable);
                this.reverseMapping[variable - literalOffset] = proposition;
            }
        }
        return this.of(formula, this.bdd.dereference(formula.accept(this.visitor)));
    }

    private BddEquivalenceClass of(@Nullable Formula representative, int node) {
        BddEquivalenceClass clazz = this.canonicalize(new BddEquivalenceClass(this, node, representative));
        if (clazz.representative == null) {
            clazz.representative = representative;
        }
        return clazz;
    }

    private BddEquivalenceClass cast(EquivalenceClass clazz) {
        if (!this.equals(clazz.factory())) {
            throw new IllegalArgumentException("Incompatible factory.");
        }
        return (BddEquivalenceClass)clazz;
    }

    private List<Map<Integer, Boolean>> nodeToDisjunctiveNormalForm(int node) {
        if (node == this.trueNode) {
            ArrayList<Map<Integer, Boolean>> list = new ArrayList<Map<Integer, Boolean>>();
            list.add(new HashMap());
            return list;
        }
        if (node == this.falseNode) {
            return new ArrayList<Map<Integer, Boolean>>();
        }
        int variable = this.bdd.variable(node);
        int highNode = this.bdd.high(node);
        int lowNode = this.bdd.low(node);
        List<Map<Integer, Boolean>> trueList = this.nodeToDisjunctiveNormalForm(highNode);
        List<Map<Integer, Boolean>> falseList = this.nodeToDisjunctiveNormalForm(lowNode);
        if (variable < this.atomicPropositions.size()) {
            assert (!this.bdd.implies(highNode, lowNode) || !this.bdd.implies(lowNode, highNode));
            if (!this.bdd.implies(highNode, lowNode)) {
                trueList.forEach(x -> x.put(variable, Boolean.TRUE));
            }
            if (!this.bdd.implies(lowNode, highNode)) {
                falseList.forEach(x -> x.put(variable, Boolean.FALSE));
            }
        } else {
            assert (this.bdd.implies(lowNode, highNode));
            trueList.forEach(x -> x.put(variable, Boolean.TRUE));
        }
        trueList.addAll(falseList);
        assert (Collections3.isDistinct(trueList));
        return Collections3.maximalElements(trueList, (x, y) -> x.entrySet().containsAll(y.entrySet()));
    }

    private DisjunctionSetView dnf(int node) {
        return new DisjunctionSetView(this.nodeToDisjunctiveNormalForm(node));
    }

    static final class BddEquivalenceClass
    implements GcManagedFactory.BddNode,
    EquivalenceClass {
        private final EquivalenceFactory factory;
        private final int node;
        @Nullable
        private Formula representative;
        @Nullable
        private Set<Formula.TemporalOperator> temporalOperatorsCache;
        @Nullable
        private BddEquivalenceClass unfoldCache;
        @Nullable
        private DisjunctionSetView disjunctiveNormalFormCache;
        private double truenessCache = Double.NaN;

        private BddEquivalenceClass(EquivalenceFactory factory, int node, @Nullable Formula internalRepresentative) {
            this.factory = factory;
            this.node = node;
            this.representative = internalRepresentative;
        }

        @Override
        public Set<Set<Formula>> disjunctiveNormalForm() {
            if (this.disjunctiveNormalFormCache == null) {
                this.disjunctiveNormalFormCache = this.factory.dnf(this.node);
            }
            return Objects.requireNonNull(this.disjunctiveNormalFormCache);
        }

        private Formula representative() {
            return Objects.requireNonNull(this.representative);
        }

        @Override
        public int node() {
            return this.node;
        }

        public String toString() {
            return this.representative == null ? String.format("%d", this.node) : PrintVisitor.toString(this.representative, this.factory.atomicPropositions, false);
        }

        @Override
        public EquivalenceClassFactory factory() {
            return this.factory;
        }

        @Override
        public boolean isFalse() {
            return this.node == this.factory.falseNode;
        }

        @Override
        public boolean isTrue() {
            return this.node == this.factory.trueNode;
        }

        @Override
        public BitSet atomicPropositions(boolean includeNested) {
            if (!includeNested) {
                return this.factory.bdd.support(this.node, this.factory.atomicPropositions.size());
            }
            BitSet atomicPropositions = this.factory.bdd.support(this.node);
            int literalOffset = this.factory.atomicPropositions.size();
            int i = atomicPropositions.nextSetBit(literalOffset);
            while (i >= 0) {
                atomicPropositions.clear(i);
                atomicPropositions.or(this.factory.reverseMapping[i - literalOffset].atomicPropositions(true));
                i = atomicPropositions.nextSetBit(i + 1);
            }
            return atomicPropositions;
        }

        @Override
        public Set<Formula.TemporalOperator> temporalOperators() {
            if (this.temporalOperatorsCache == null) {
                BitSet support = this.factory.bdd.support(this.node);
                int literalOffset = this.factory.atomicPropositions.size();
                support.clear(0, literalOffset);
                this.temporalOperatorsCache = support.stream().mapToObj(i -> this.factory.reverseMapping[i - literalOffset]).collect(Collectors.toUnmodifiableSet());
            }
            return this.temporalOperatorsCache;
        }

        @Override
        public boolean implies(EquivalenceClass other) {
            return this.factory.bdd.implies(this.node, this.factory.cast((EquivalenceClass)other).node);
        }

        @Override
        public EquivalenceClass and(EquivalenceClass other) {
            BddEquivalenceClass otherCasted = this.factory.cast(other);
            return this.factory.of(Conjunction.of(this.representative(), otherCasted.representative()), this.factory.bdd.and(this.node, otherCasted.node));
        }

        @Override
        public EquivalenceClass or(EquivalenceClass other) {
            BddEquivalenceClass otherCasted = this.factory.cast(other);
            return this.factory.of(Disjunction.of(this.representative(), otherCasted.representative()), this.factory.bdd.or(this.node, otherCasted.node));
        }

        @Override
        public EquivalenceClass substitute(Function<? super Formula.TemporalOperator, ? extends Formula> substitution) {
            return this.factory.of(this.representative().substitute(substitution), true);
        }

        @Override
        public EquivalenceClass temporalStep(BitSet valuation) {
            return this.factory.of(this.representative().temporalStep(valuation), false);
        }

        @Override
        public <T> ValuationTree<T> temporalStepTree(Function<EquivalenceClass, Set<T>> mapper) {
            if (this.factory.temporalStepTreeCache == null || !mapper.equals(this.factory.temporalStepTreeCachedMapper)) {
                this.factory.temporalStepTreeCachedMapper = mapper;
                this.factory.temporalStepTreeCache = new IdentityHashMap();
            }
            return this.temporalStepTree(this.representative(), new BitSet(), mapper, this.factory.temporalStepTreeCache);
        }

        private <T> ValuationTree<T> temporalStepTree(Formula initialRepresentative, BitSet pathTrace, Function<EquivalenceClass, Set<T>> mapper, IdentityHashMap<EquivalenceClass, ValuationTree<T>> cache) {
            int atom;
            ValuationTree<Object> tree = cache.get(this);
            if (tree != null) {
                return tree;
            }
            List<String> alphabet = this.factory.atomicPropositions;
            Bdd bdd = this.factory.bdd;
            int n = atom = bdd.isNodeRoot(this.node) ? alphabet.size() : bdd.variable(this.node);
            if (atom >= alphabet.size()) {
                tree = ValuationTree.of((Collection)mapper.apply(this.factory.of(initialRepresentative.temporalStep(pathTrace), false)));
            } else {
                pathTrace.set(atom);
                ValuationTree<T> trueSubTree = this.factory.of(null, bdd.high(this.node)).temporalStepTree(initialRepresentative, pathTrace, mapper, cache);
                pathTrace.clear(atom, pathTrace.length());
                ValuationTree<T> falseSubTree = this.factory.of(null, bdd.low(this.node)).temporalStepTree(initialRepresentative, pathTrace, mapper, cache);
                tree = ValuationTree.of(atom, trueSubTree, falseSubTree);
            }
            cache.put(this, tree);
            return tree;
        }

        @Override
        public EquivalenceClass unfold() {
            if (this.unfoldCache == null) {
                this.unfoldCache = this.factory.of(this.representative().unfold(), false);
                if (this.unfoldCache.unfoldCache == null) {
                    this.unfoldCache.unfoldCache = this.unfoldCache;
                } else assert (this.unfoldCache.unfoldCache.equals(this.unfoldCache));
            }
            return this.unfoldCache;
        }

        @Override
        public double trueness() {
            if (this.isTrue()) {
                return 1.0;
            }
            if (this.isFalse()) {
                return 0.0;
            }
            if (Double.isNaN(this.truenessCache)) {
                BigDecimal satisfyingAssignments = new BigDecimal(this.factory.bdd.countSatisfyingAssignments(this.node));
                BigDecimal assignments = BigDecimal.valueOf(2L).pow(this.factory.bdd.numberOfVariables());
                this.truenessCache = satisfyingAssignments.divide(assignments, 24, RoundingMode.HALF_DOWN).doubleValue();
            }
            return this.truenessCache;
        }

        public boolean equals(Object obj) {
            assert (!(obj instanceof EquivalenceClass) || ((EquivalenceClass)obj).factory() == this.factory());
            return this == obj;
        }
    }

    private class ConjunctionSetView
    extends AbstractSet<Formula> {
        private final Map<Integer, Boolean> clause;

        private ConjunctionSetView(Map<Integer, Boolean> clause) {
            this.clause = clause;
        }

        @Override
        public Iterator<Formula> iterator() {
            class Iter
            implements Iterator<Formula> {
                private final Iterator<Map.Entry<Integer, Boolean>> iterator;

                Iter() {
                    this.iterator = ConjunctionSetView.this.clause.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public Formula next() {
                    return ConjunctionSetView.this.toFormula(this.iterator.next());
                }
            }
            return new Iter();
        }

        @Override
        public Stream<Formula> stream() {
            return this.clause.entrySet().stream().map(this::toFormula);
        }

        @Override
        public int size() {
            return this.clause.size();
        }

        private Formula toFormula(Map.Entry<Integer, Boolean> entry) {
            int literalOffset = EquivalenceFactory.this.atomicPropositions.size();
            if (entry.getKey() < literalOffset) {
                return Literal.of(entry.getKey(), entry.getValue() == false);
            }
            assert (entry.getValue().booleanValue()) : "Only positive temporal operators expected.";
            return EquivalenceFactory.this.reverseMapping[entry.getKey() - literalOffset];
        }
    }

    private class DisjunctionSetView
    extends AbstractSet<Set<Formula>> {
        private final List<Map<Integer, Boolean>> disjunctiveNormalForm;

        private DisjunctionSetView(List<Map<Integer, Boolean>> disjunctiveNormalForm) {
            this.disjunctiveNormalForm = disjunctiveNormalForm.stream().map(Map::copyOf).collect(Collectors.toUnmodifiableList());
        }

        @Override
        public Iterator<Set<Formula>> iterator() {
            class Iter
            implements Iterator<Set<Formula>> {
                private final Iterator<Map<Integer, Boolean>> iterator;

                Iter() {
                    this.iterator = DisjunctionSetView.this.disjunctiveNormalForm.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public Set<Formula> next() {
                    return new ConjunctionSetView(this.iterator.next());
                }
            }
            return new Iter();
        }

        @Override
        public Stream<Set<Formula>> stream() {
            return this.disjunctiveNormalForm.stream().map(x$0 -> new ConjunctionSetView((Map<Integer, Boolean>)x$0));
        }

        @Override
        public int size() {
            return this.disjunctiveNormalForm.size();
        }
    }

    private final class BddVisitor
    extends PropositionalIntVisitor {
        private BddVisitor() {
        }

        @Override
        public int visit(Literal literal) {
            Preconditions.checkArgument((literal.getAtom() < EquivalenceFactory.this.atomicPropositions.size() ? 1 : 0) != 0);
            int node = EquivalenceFactory.this.bdd.variableNode(literal.getAtom());
            return literal.isNegated() ? EquivalenceFactory.this.bdd.not(node) : node;
        }

        @Override
        protected int visit(Formula.TemporalOperator formula) {
            int variable = EquivalenceFactory.this.mapping.get(formula);
            assert (variable >= 0);
            return EquivalenceFactory.this.bdd.variableNode(variable);
        }

        @Override
        public int visit(BooleanConstant booleanConstant) {
            return booleanConstant.value ? EquivalenceFactory.this.trueNode : EquivalenceFactory.this.falseNode;
        }

        @Override
        public int visit(Conjunction conjunction) {
            int x = EquivalenceFactory.this.trueNode;
            for (Formula child : Lists.reverse((List)conjunction.operands)) {
                int y = child.accept(this);
                x = EquivalenceFactory.this.bdd.consume(EquivalenceFactory.this.bdd.and(x, y), x, y);
            }
            return x;
        }

        @Override
        public int visit(Disjunction disjunction) {
            int x = EquivalenceFactory.this.falseNode;
            for (Formula child : Lists.reverse((List)disjunction.operands)) {
                int y = child.accept(this);
                x = EquivalenceFactory.this.bdd.consume(EquivalenceFactory.this.bdd.or(x, y), x, y);
            }
            return x;
        }
    }
}

