/*
 * Decompiled with CFR 0.152.
 */
package owl.factories.jbdd;

import de.tum.in.jbdd.Bdd;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;

class GcManagedFactory<V extends BddNode> {
    private static final Logger logger = Logger.getLogger(GcManagedFactory.class.getName());
    final Bdd bdd;
    private final Int2ObjectMap<BddNodeReference<V>> gcObjects = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<V> nonGcObjects = new Int2ObjectOpenHashMap();
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    GcManagedFactory(Bdd bdd) {
        this.bdd = bdd;
    }

    V canonicalize(V wrapper) {
        int node = wrapper.node();
        if (this.bdd.isNodeRoot(node) || this.bdd.isVariableOrNegated(node)) {
            assert (this.bdd.getReferenceCount(node) == -1) : GcManagedFactory.reportReferenceCountMismatch(-1, this.bdd.getReferenceCount(node));
            return (V)((BddNode)this.nonGcObjects.merge(node, wrapper, (oldWrapper, newWrapper) -> oldWrapper));
        }
        BddNodeReference canonicalReference = (BddNodeReference)this.gcObjects.get(node);
        if (canonicalReference == null) {
            assert (this.bdd.getReferenceCount(node) == 0) : GcManagedFactory.reportReferenceCountMismatch(0, this.bdd.getReferenceCount(node));
            this.bdd.reference(node);
        } else {
            assert (this.bdd.getReferenceCount(node) == 1) : GcManagedFactory.reportReferenceCountMismatch(1, this.bdd.getReferenceCount(node));
            BddNode canonicalWrapper = (BddNode)canonicalReference.get();
            if (canonicalWrapper == null) {
                canonicalReference.enqueue();
            } else {
                assert (node == canonicalWrapper.node());
                return (V)canonicalWrapper;
            }
        }
        assert (this.bdd.getReferenceCount(node) == 1);
        this.processReferenceQueue(node);
        this.gcObjects.put(node, new BddNodeReference<V>(wrapper, this.queue));
        assert (this.bdd.getReferenceCount(node) == 1);
        return wrapper;
    }

    private void processReferenceQueue(int protectedNode) {
        Reference<V> reference = this.queue.poll();
        if (reference == null) {
            return;
        }
        int count = 0;
        do {
            int node = ((BddNodeReference)reference).node;
            this.gcObjects.remove(node);
            if (node == protectedNode) continue;
            assert (this.bdd.getReferenceCount(node) == 1);
            this.bdd.dereference(node);
            assert (this.bdd.getReferenceCount(node) == 0);
            ++count;
        } while ((reference = this.queue.poll()) != null);
        logger.log(Level.FINEST, "Cleared {0} references", count);
    }

    private static String reportReferenceCountMismatch(int expected, int actual) {
        return String.format("Expected reference count {%d}, but actual count is {%d}.", expected, actual);
    }

    static interface BddNode {
        public int node();
    }

    private static final class BddNodeReference<V extends BddNode>
    extends WeakReference<V> {
        private final int node;

        private BddNodeReference(V wrapper, ReferenceQueue<? super V> queue) {
            super(wrapper, queue);
            this.node = wrapper.node();
        }
    }
}

