/*
 * Decompiled with CFR 0.152.
 */
package owl.game.output;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import owl.game.output.Aig;
import owl.game.output.LabelledAig;

public final class AigFactory {
    private final Map<Aig, Aig> cache = new HashMap<Aig, Aig>();

    public AigFactory() {
        this.cache.put(Aig.FALSE, Aig.FALSE);
    }

    public LabelledAig getNode(int variable) {
        return this.createNode(variable);
    }

    public LabelledAig getTrue() {
        return this.not(LabelledAig.of(Aig.FALSE));
    }

    public LabelledAig getFalse() {
        return LabelledAig.of(Aig.FALSE);
    }

    public LabelledAig conjunction(LabelledAig left, LabelledAig right) {
        return this.createNode(left, right);
    }

    public LabelledAig cube(BitSet b) {
        LabelledAig product = this.getTrue();
        for (int i = 0; i <= b.size(); ++i) {
            LabelledAig lit = b.get(i) ? this.getNode(i + 1) : this.not(this.getNode(i + 1));
            product = this.conjunction(product, lit);
        }
        return product;
    }

    public LabelledAig disjunction(LabelledAig left, LabelledAig right) {
        return this.createNode(left.flip(), right.flip()).flip();
    }

    public LabelledAig not(LabelledAig a) {
        return a.flip();
    }

    private LabelledAig createNode(int variable) {
        return LabelledAig.of(this.makeUnique(Aig.leaf(variable)));
    }

    private LabelledAig createNode(LabelledAig left, LabelledAig right) {
        LabelledAig realLeft = left.isNegated() && left.equals(this.getTrue()) ? this.getFalse() : (left.isNegated() && left.equals(this.getFalse()) ? this.getTrue() : left);
        LabelledAig realRight = right.isNegated() && right.equals(this.getTrue()) ? this.getFalse() : (right.isNegated() && right.equals(this.getFalse()) ? this.getTrue() : right);
        return LabelledAig.of(this.makeUnique(Aig.node(realLeft.aig(), realLeft.isNegated(), realRight.aig(), realRight.isNegated())));
    }

    private Aig makeUnique(Aig object) {
        Aig unique = this.cache.putIfAbsent(object, object);
        return unique == null ? object : unique;
    }
}

