/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import com.google.auto.value.AutoValue;
import java.util.List;
import java.util.stream.Collectors;
import owl.ltl.AutoValue_SyntacticFragments_FormulaClass;
import owl.ltl.Biconditional;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.Negation;
import owl.ltl.ROperator;
import owl.ltl.UOperator;
import owl.ltl.WOperator;
import owl.ltl.XOperator;

public final class SyntacticFragments {
    public static final FormulaClass DELTA_0 = FormulaClass.of(Type.DELTA, 0);
    public static final FormulaClass SIGMA_1 = FormulaClass.of(Type.SIGMA, 1);
    public static final FormulaClass PI_1 = FormulaClass.of(Type.PI, 1);
    public static final FormulaClass DELTA_1 = FormulaClass.of(Type.DELTA, 1);
    public static final FormulaClass SIGMA_2 = FormulaClass.of(Type.SIGMA, 2);
    public static final FormulaClass PI_2 = FormulaClass.of(Type.PI, 2);
    public static final FormulaClass DELTA_2 = FormulaClass.of(Type.DELTA, 2);

    private SyntacticFragments() {
    }

    public static boolean isSingleStep(Formula formula) {
        return SyntacticFragments.isFinite(formula) && formula.subformulas(XOperator.class).isEmpty();
    }

    public static boolean isFinite(Formula formula) {
        return DELTA_0.contains(formula);
    }

    public static boolean isFinite(EquivalenceClass clazz) {
        for (Formula.TemporalOperator temporalOperator : clazz.temporalOperators()) {
            if (SyntacticFragments.isFinite(temporalOperator)) continue;
            return false;
        }
        return true;
    }

    public static boolean isCoSafety(Formula formula) {
        return SIGMA_1.contains(formula);
    }

    public static boolean isCoSafety(EquivalenceClass clazz) {
        for (Formula.TemporalOperator temporalOperator : clazz.temporalOperators()) {
            if (SyntacticFragments.isCoSafety(temporalOperator)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSafety(Formula formula) {
        return PI_1.contains(formula);
    }

    public static boolean isSafety(EquivalenceClass clazz) {
        for (Formula.TemporalOperator temporalOperator : clazz.temporalOperators()) {
            if (SyntacticFragments.isSafety(temporalOperator)) continue;
            return false;
        }
        return true;
    }

    public static boolean isGfCoSafety(Formula formula) {
        if (formula instanceof GOperator) {
            Formula unwrapped = ((GOperator)formula).operand();
            return unwrapped instanceof FOperator && SyntacticFragments.isCoSafety(unwrapped);
        }
        return false;
    }

    public static boolean isGCoSafety(Formula formula) {
        if (formula instanceof GOperator) {
            Formula unwrapped = ((GOperator)formula).operand();
            return SyntacticFragments.isCoSafety(unwrapped);
        }
        return false;
    }

    public static boolean isFgSafety(Formula formula) {
        if (formula instanceof FOperator) {
            Formula unwrapped = ((FOperator)formula).operand();
            return unwrapped instanceof GOperator && SyntacticFragments.isSafety(unwrapped);
        }
        return false;
    }

    public static boolean isFSafety(Formula formula) {
        if (formula instanceof FOperator) {
            Formula unwrapped = ((FOperator)formula).operand();
            return SyntacticFragments.isSafety(unwrapped);
        }
        return false;
    }

    public static boolean isCoSafetySafety(Formula formula) {
        return SIGMA_2.contains(formula);
    }

    public static boolean isSafetyCoSafety(Formula formula) {
        return PI_2.contains(formula);
    }

    public static boolean isAlmostAll(Formula formula) {
        return formula instanceof FOperator && ((FOperator)formula).operand() instanceof GOperator;
    }

    public static boolean isInfinitelyOften(Formula formula) {
        return formula instanceof GOperator && ((GOperator)formula).operand() instanceof FOperator;
    }

    @AutoValue
    public static abstract class FormulaClass {
        public abstract Type type();

        public abstract int level();

        public static FormulaClass of(Type type, int level) {
            return new AutoValue_SyntacticFragments_FormulaClass(type, level);
        }

        public static FormulaClass classify(Formula formula) {
            if (formula instanceof Biconditional || formula instanceof Negation) {
                throw new IllegalArgumentException("Formula not in negation normal form.");
            }
            FormulaClass childrenClass = FormulaClass.leastUpperBound(formula.operands.stream().map(FormulaClass::classify).collect(Collectors.toList()));
            if (formula instanceof FOperator || formula instanceof MOperator || formula instanceof UOperator) {
                if (childrenClass.type() == Type.SIGMA) {
                    return childrenClass;
                }
                return FormulaClass.of(Type.SIGMA, childrenClass.level() + 1);
            }
            if (formula instanceof GOperator || formula instanceof ROperator || formula instanceof WOperator) {
                if (childrenClass.type() == Type.PI) {
                    return childrenClass;
                }
                return FormulaClass.of(Type.PI, childrenClass.level() + 1);
            }
            assert (formula instanceof BooleanConstant || formula instanceof Conjunction || formula instanceof Disjunction || formula instanceof Literal || formula instanceof XOperator);
            return childrenClass;
        }

        public static FormulaClass leastUpperBound(List<FormulaClass> list) {
            switch (list.size()) {
                case 0: {
                    return DELTA_0;
                }
                case 1: {
                    return list.get(0);
                }
            }
            FormulaClass lub = DELTA_0;
            for (FormulaClass element : list) {
                lub = lub.leastUpperBound(element);
            }
            return lub;
        }

        public boolean contains(Formula formula) {
            try {
                return FormulaClass.classify(formula).lessOrEquals(this);
            }
            catch (IllegalArgumentException ex) {
                return false;
            }
        }

        public FormulaClass leastUpperBound(FormulaClass that) {
            if (this.lessOrEquals(that)) {
                return that;
            }
            if (that.lessOrEquals(this)) {
                return this;
            }
            assert (this.level() == that.level());
            assert (this.type() != that.type());
            assert (this.type() != Type.DELTA);
            assert (that.type() != Type.DELTA);
            return FormulaClass.of(Type.DELTA, this.level());
        }

        public boolean lessOrEquals(FormulaClass that) {
            if (this.level() < that.level()) {
                return true;
            }
            if (this.level() == that.level()) {
                return that.type() == Type.DELTA || this.type() == that.type();
            }
            return false;
        }
    }

    public static enum Type {
        SIGMA,
        DELTA,
        PI;

    }
}

