/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.wbs;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileBox;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.mindmap.IdeaShape;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.wbs.WElement;

public abstract class WBSTextBlock
extends AbstractTextBlock {
    protected final ISkinParam skinParam;

    public WBSTextBlock(ISkinParam skinParam) {
        this.skinParam = skinParam;
    }

    protected final HtmlColor getLinkColor() {
        return ColorParam.activityBorder.getDefaultValue();
    }

    protected final void drawLine(UGraphic ug, Point2D p1, Point2D p2) {
        ULine line = new ULine(p1, p2);
        ug.apply(new UTranslate(p1)).apply(new UChangeColor(this.getLinkColor())).draw(line);
    }

    protected final void drawLine(UGraphic ug, double x1, double y1, double x2, double y2) {
        this.drawLine(ug, new Point2D.Double(x1, y1), new Point2D.Double(x2, y2));
    }

    protected final TextBlock buildMain(WElement idea) {
        Display label = idea.getLabel();
        UFont font = this.skinParam.getFont(null, false, FontParam.ACTIVITY);
        if (idea.getShape() == IdeaShape.BOX) {
            FtileBox box = new FtileBox(Colors.empty().mute(this.skinParam), label, font, null, BoxStyle.SDL_TASK);
            return box;
        }
        TextBlock text = label.create(FontConfiguration.blackBlueTrue(font), HorizontalAlignment.LEFT, this.skinParam);
        return TextBlockUtils.withMargin(text, 0.0, 3.0, 1.0, 1.0);
    }
}

