/*
 * Decompiled with CFR 0.152.
 */
package org.svvrl.goal.misc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import org.java.plugin.boot.SplashHandler;
import org.java.plugin.util.ExtendedProperties;

public class SplashWindow
extends JWindow
implements SplashHandler {
    private static final long serialVersionUID = 1084917843201434116L;
    private URL url = null;
    private JLabel label = new JLabel();
    private JProgressBar progress = new JProgressBar();
    public static final String MAX_PROGRESS_KEY = "MaxProgress";

    public SplashWindow() {
        this.progress.setIndeterminate(false);
        this.progress.setStringPainted(true);
        this.setProgress(0.0f);
        this.setText("Initializing");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.label, "Center");
        container.add((Component)this.progress, "South");
    }

    public void configure(ExtendedProperties ep) {
        String str = ep.getProperty(MAX_PROGRESS_KEY);
        if (str != null) {
            try {
                int max = Integer.valueOf(str);
                this.progress.setMaximum(max);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public URL getImage() {
        return this.url;
    }

    public Object getImplementation() {
        return this;
    }

    public float getProgress() {
        return this.progress.getValue();
    }

    public String getText() {
        return this.progress.getString();
    }

    public void setImage(URL e) {
        this.url = e;
        this.label.setIcon(new ImageIcon(this.url));
        this.pack();
    }

    public void setProgress(float p) {
        System.out.println("Set progress: " + p);
        this.progress.setValue((int)(p * 100.0f));
    }

    public void setText(String s) {
        this.progress.setString(s);
    }

    @Override
    public void setVisible(boolean b) {
        Dimension size = this.getSize();
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        Point location = new Point(center.x - (size.width >> 1), center.y - (size.height >> 1));
        this.setLocation(location);
        super.setVisible(b);
    }
}

