/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.bitset;

import com.zaxxer.sparsebits.SparseBitSet;
import de.tum.in.naturals.bitset.BitSets;
import de.tum.in.naturals.bitset.SparseBitSetComplementIterator;
import de.tum.in.naturals.bitset.SparseBitSetIterator;
import de.tum.in.naturals.set.NatBitSet;
import de.tum.in.naturals.set.NatBitSets;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.BitSet;
import java.util.PrimitiveIterator;
import java.util.function.IntConsumer;

public final class SparseBitSets {
    private SparseBitSets() {
    }

    public static SparseBitSet of(int ... indices) {
        SparseBitSet bitSet = new SparseBitSet();
        for (int index : indices) {
            bitSet.set(index);
        }
        return bitSet;
    }

    public static SparseBitSet of(IntIterable iterable) {
        IntSortedSet sortedSet;
        if (iterable instanceof NatBitSet) {
            return NatBitSets.toSparseBitSet((NatBitSet)iterable);
        }
        SparseBitSet bitSet = iterable instanceof IntSortedSet ? ((sortedSet = (IntSortedSet)iterable).comparator() == null ? new SparseBitSet(sortedSet.lastInt() + 1) : new SparseBitSet()) : new SparseBitSet();
        iterable.forEach(arg_0 -> ((SparseBitSet)bitSet).set(arg_0));
        return bitSet;
    }

    public static SparseBitSet of(Iterable<Integer> iterable) {
        if (iterable instanceof IntIterable) {
            return SparseBitSets.of((IntIterable)iterable);
        }
        SparseBitSet bitSet = new SparseBitSet();
        iterable.forEach(arg_0 -> ((SparseBitSet)bitSet).set(arg_0));
        return bitSet;
    }

    public static SparseBitSet of(PrimitiveIterator.OfInt iterator) {
        SparseBitSet sparseBitSet = new SparseBitSet();
        iterator.forEachRemaining(arg_0 -> ((SparseBitSet)sparseBitSet).set(arg_0));
        return sparseBitSet;
    }

    public static SparseBitSet of(BitSet bitSet) {
        SparseBitSet sparseBitSet = new SparseBitSet(bitSet.length());
        BitSets.forEach(bitSet, arg_0 -> ((SparseBitSet)sparseBitSet).set(arg_0));
        return sparseBitSet;
    }

    public static IntIterator complementIterator(SparseBitSet bitSet, int length) {
        return new SparseBitSetComplementIterator(bitSet, length);
    }

    public static void forEach(SparseBitSet bitSet, IntConsumer consumer) {
        int cardinality;
        int length = bitSet.length();
        if (length < (cardinality = bitSet.cardinality()) * 2) {
            int currentBlock = bitSet.nextSetBit(0);
            while (currentBlock > -1) {
                int blockEnd = bitSet.nextClearBit(currentBlock);
                assert (blockEnd > currentBlock);
                for (int i = currentBlock; i < blockEnd; ++i) {
                    consumer.accept(i);
                }
                currentBlock = bitSet.nextSetBit(blockEnd);
            }
        } else {
            int i = bitSet.nextSetBit(0);
            while (i >= 0) {
                consumer.accept(i);
                i = bitSet.nextSetBit(i + 1);
            }
        }
    }

    public static boolean isSubset(SparseBitSet first, SparseBitSet second) {
        int i = first.nextSetBit(0);
        while (i >= 0) {
            if (!second.get(i)) {
                return false;
            }
            i = first.nextSetBit(i + 1);
        }
        return true;
    }

    public static boolean isDisjoint(SparseBitSet first, SparseBitSet second) {
        return !first.intersects(second);
    }

    public static IntIterator iterator(SparseBitSet bitSet) {
        return new SparseBitSetIterator(bitSet);
    }

    public static IntIterator iterator(SparseBitSet bitSet, int length) {
        return new SparseBitSetIterator(bitSet, length);
    }
}

