/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.set;

import de.tum.in.naturals.bitset.BitSets;
import de.tum.in.naturals.set.AbstractBoundedNatBitSet;
import de.tum.in.naturals.set.NatBitSetsUtil;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.BitSet;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;

class SimpleBoundedNatBitSet
extends AbstractBoundedNatBitSet {
    private final BitSet bitSet;
    private final boolean complement;
    private final SimpleBoundedNatBitSet complementView;

    private SimpleBoundedNatBitSet(SimpleBoundedNatBitSet other) {
        super(other.domainSize());
        this.bitSet = other.bitSet;
        this.complement = !other.complement;
        this.complementView = other;
        assert (this.checkConsistency());
    }

    private SimpleBoundedNatBitSet(BitSet bitSet, @Nonnegative int domainSize, boolean complement) {
        super(domainSize);
        this.bitSet = bitSet;
        this.complement = complement;
        this.complementView = new SimpleBoundedNatBitSet(this);
        assert (this.checkConsistency());
    }

    SimpleBoundedNatBitSet(BitSet bitSet, @Nonnegative int domainSize) {
        this(bitSet, domainSize, false);
    }

    @Override
    public void and(IntCollection indices) {
        assert (this.checkConsistency());
        if (indices.isEmpty()) {
            this.clear();
        } else if (indices instanceof SimpleBoundedNatBitSet) {
            SimpleBoundedNatBitSet other = (SimpleBoundedNatBitSet)indices;
            if (this.complement) {
                this.bitSet.or(other.complement ? other.bitSet : other.complementBits());
                int domainSize = this.domainSize();
                int otherDomainSize = other.domainSize();
                if (domainSize < otherDomainSize) {
                    this.bitSet.clear(domainSize, otherDomainSize);
                } else {
                    this.bitSet.set(otherDomainSize, domainSize);
                }
            } else if (other.complement) {
                this.bitSet.andNot(other.bitSet);
                int domainSize = this.domainSize();
                int otherDomainSize = other.domainSize();
                if (otherDomainSize < domainSize) {
                    this.bitSet.clear(otherDomainSize, domainSize);
                }
            } else {
                this.bitSet.and(other.bitSet);
            }
        } else {
            super.and(indices);
        }
        assert (this.checkConsistency());
    }

    @Override
    public void andNot(IntCollection indices) {
        assert (this.checkConsistency());
        if (indices.isEmpty()) {
            return;
        }
        if (indices instanceof SimpleBoundedNatBitSet) {
            SimpleBoundedNatBitSet other = (SimpleBoundedNatBitSet)indices;
            if (this.complement) {
                this.bitSet.or(other.complement ? other.complementBits() : other.bitSet);
                int domainSize = this.domainSize();
                int otherDomainSize = other.domainSize();
                if (domainSize < otherDomainSize) {
                    this.bitSet.clear(domainSize, otherDomainSize);
                }
            } else if (other.complement) {
                int domainSize = this.domainSize();
                int otherDomainSize = other.domainSize();
                if (otherDomainSize < domainSize) {
                    BitSet clone = (BitSet)other.bitSet.clone();
                    clone.set(otherDomainSize, domainSize);
                    this.bitSet.and(clone);
                } else {
                    this.bitSet.and(other.bitSet);
                }
            } else {
                this.bitSet.andNot(other.bitSet);
            }
        } else {
            super.andNot(indices);
        }
        assert (this.checkConsistency());
    }

    private boolean checkConsistency() {
        return this.bitSet.length() <= this.domainSize();
    }

    @Override
    public void clear(int index) {
        assert (this.checkConsistency());
        this.checkInDomain(index);
        this.bitSet.set(index, this.complement);
        assert (this.checkConsistency());
    }

    @Override
    public void clear(int from, int to) {
        assert (this.checkConsistency());
        this.checkInDomain(from, to);
        if (this.complement) {
            this.bitSet.set(from, to);
        } else {
            this.bitSet.clear(from, to);
        }
        assert (this.checkConsistency());
    }

    @Override
    public SimpleBoundedNatBitSet clone() {
        assert (this.checkConsistency());
        return new SimpleBoundedNatBitSet((BitSet)this.bitSet.clone(), this.domainSize(), this.complement);
    }

    @Override
    public SimpleBoundedNatBitSet complement() {
        return this.complementView;
    }

    private BitSet complementBits() {
        BitSet copy = (BitSet)this.bitSet.clone();
        copy.flip(0, this.domainSize());
        return copy;
    }

    public boolean contains(int k) {
        return 0 <= k && (this.complement ? k < this.domainSize() && !this.bitSet.get(k) : this.bitSet.get(k));
    }

    public boolean containsAll(IntCollection indices) {
        assert (this.checkConsistency());
        if (this.isEmpty()) {
            return indices.isEmpty();
        }
        if (indices.isEmpty()) {
            return true;
        }
        if (indices instanceof SimpleBoundedNatBitSet) {
            SimpleBoundedNatBitSet other = (SimpleBoundedNatBitSet)indices;
            int otherLastInt = other.lastInt();
            if (!this.inDomain(otherLastInt) || this.lastInt() < otherLastInt) {
                return false;
            }
            BitSet otherSetBits = other.complement ? other.complementBits() : other.bitSet;
            BitSet unsetBits = this.complement ? this.bitSet : this.complementBits();
            return !unsetBits.intersects(otherSetBits);
        }
        return super.containsAll(indices);
    }

    public boolean equals(Object o) {
        assert (this.checkConsistency());
        if (this == o) {
            return true;
        }
        if (o instanceof SimpleBoundedNatBitSet) {
            SimpleBoundedNatBitSet nonComplementSet;
            SimpleBoundedNatBitSet other = (SimpleBoundedNatBitSet)o;
            if (this.isEmpty()) {
                return other.isEmpty();
            }
            int domainSize = this.domainSize();
            int otherDomainSize = other.domainSize();
            if (this.complement) {
                if (other.complement) {
                    int largerSize;
                    int smallerSize;
                    SimpleBoundedNatBitSet larger;
                    SimpleBoundedNatBitSet smaller;
                    if (domainSize == otherDomainSize) {
                        return this.bitSet.equals(other.bitSet);
                    }
                    if (domainSize < otherDomainSize) {
                        smaller = this;
                        larger = other;
                        smallerSize = domainSize;
                        largerSize = otherDomainSize;
                    } else {
                        smaller = other;
                        larger = this;
                        smallerSize = otherDomainSize;
                        largerSize = domainSize;
                    }
                    if (larger.bitSet.nextClearBit(smallerSize) < largerSize) {
                        return false;
                    }
                    BitSet largerBitSet = (BitSet)larger.bitSet.clone();
                    largerBitSet.clear(smallerSize, largerSize);
                    return smaller.bitSet.equals(largerBitSet);
                }
            } else if (!other.complement) {
                return this.bitSet.equals(other.bitSet);
            }
            int complementDomainSize = this.complement ? domainSize : otherDomainSize;
            SimpleBoundedNatBitSet simpleBoundedNatBitSet = nonComplementSet = this.complement ? other : this;
            assert (!nonComplementSet.complement);
            return !this.bitSet.intersects(other.bitSet) && this.bitSet.cardinality() + other.bitSet.cardinality() == complementDomainSize && (domainSize == otherDomainSize || nonComplementSet.lastInt() < complementDomainSize);
        }
        return super.equals(o);
    }

    @Override
    public void flip(int index) {
        assert (this.checkConsistency());
        this.checkInDomain(index);
        this.bitSet.flip(index);
        assert (this.checkConsistency());
    }

    @Override
    public void flip(int from, int to) {
        assert (this.checkConsistency());
        this.checkInDomain(from, to);
        this.bitSet.flip(from, to);
        assert (this.checkConsistency());
    }

    BitSet getBitSet() {
        return this.bitSet;
    }

    public int hashCode() {
        return (this.complement ? ~this.bitSet.hashCode() : this.bitSet.hashCode()) ^ HashCommon.mix((int)this.domainSize());
    }

    @Override
    boolean isComplement() {
        return this.complement;
    }

    public boolean isEmpty() {
        assert (this.checkConsistency());
        return this.complement ? this.bitSet.nextClearBit(0) == this.domainSize() : this.bitSet.isEmpty();
    }

    @Override
    public IntIterator iterator() {
        assert (this.checkConsistency());
        return this.complement ? BitSets.complementIterator(this.bitSet, this.domainSize()) : BitSets.iterator(this.bitSet, this.domainSize());
    }

    @Override
    public int lastInt() {
        int lastInt;
        int n = lastInt = this.complement ? this.bitSet.previousClearBit(this.domainSize() - 1) : this.bitSet.length() - 1;
        if (lastInt == -1) {
            throw new NoSuchElementException();
        }
        assert (lastInt < this.domainSize());
        return lastInt;
    }

    @Override
    public int nextAbsentIndex(int index) {
        assert (this.checkConsistency());
        NatBitSetsUtil.checkNonNegative(index);
        if (index >= this.domainSize()) {
            return index;
        }
        if (this.complement) {
            int nextSet = this.bitSet.nextSetBit(index);
            return nextSet == -1 ? this.domainSize() : nextSet;
        }
        return this.bitSet.nextClearBit(index);
    }

    @Override
    public int nextPresentIndex(int index) {
        assert (this.checkConsistency());
        NatBitSetsUtil.checkNonNegative(index);
        if (index >= this.domainSize()) {
            return -1;
        }
        if (this.complement) {
            int nextClear = this.bitSet.nextClearBit(index);
            return nextClear >= this.domainSize() ? -1 : nextClear;
        }
        return this.bitSet.nextSetBit(index);
    }

    @Override
    public void or(IntCollection indices) {
        assert (this.checkConsistency());
        if (indices.isEmpty()) {
            return;
        }
        if (indices instanceof SimpleBoundedNatBitSet) {
            SimpleBoundedNatBitSet other = (SimpleBoundedNatBitSet)indices;
            this.checkInDomain(other.lastInt());
            if (this.complement) {
                if (other.complement) {
                    BitSet otherBitSet;
                    int domainSize;
                    int otherDomainSize = other.domainSize();
                    if (otherDomainSize <= (domainSize = this.domainSize())) {
                        otherBitSet = (BitSet)other.bitSet.clone();
                        otherBitSet.set(otherDomainSize, domainSize);
                    } else {
                        otherBitSet = other.bitSet;
                    }
                    this.bitSet.and(otherBitSet);
                } else {
                    this.bitSet.andNot(other.bitSet);
                }
            } else if (other.complement) {
                this.bitSet.or(other.complementBits());
            } else {
                this.bitSet.or(other.bitSet);
            }
        } else {
            super.or(indices);
        }
        assert (this.checkConsistency());
    }

    @Override
    public int previousAbsentIndex(int index) {
        assert (this.checkConsistency());
        NatBitSetsUtil.checkNonNegative(index);
        if (index >= this.domainSize()) {
            return index;
        }
        return this.complement ? this.bitSet.previousSetBit(index) : this.bitSet.previousClearBit(index);
    }

    @Override
    public int previousPresentIndex(int index) {
        assert (this.checkConsistency());
        NatBitSetsUtil.checkNonNegative(index);
        int clampedIndex = Math.min(index, this.domainSize() - 1);
        return this.complement ? this.bitSet.previousClearBit(clampedIndex) : this.bitSet.previousSetBit(clampedIndex);
    }

    @Override
    public void orNot(IntCollection indices) {
        assert (this.checkConsistency());
        if (indices.isEmpty()) {
            if (this.complement) {
                this.bitSet.clear();
            } else {
                this.bitSet.set(0, this.domainSize());
            }
        } else if (indices instanceof SimpleBoundedNatBitSet) {
            SimpleBoundedNatBitSet other = (SimpleBoundedNatBitSet)indices;
            int domainSize = this.domainSize();
            int otherDomainSize = other.domainSize();
            if (this.complement) {
                if (other.complement) {
                    this.bitSet.andNot(other.bitSet);
                    if (otherDomainSize < domainSize) {
                        this.bitSet.clear(otherDomainSize, domainSize);
                    }
                } else {
                    this.bitSet.and(other.bitSet);
                }
            } else if (other.complement) {
                this.bitSet.or(other.bitSet);
                if (otherDomainSize < domainSize) {
                    this.bitSet.set(otherDomainSize, domainSize);
                } else {
                    this.bitSet.clear(domainSize, otherDomainSize);
                }
            } else {
                int minDomainSize = Math.min(domainSize, otherDomainSize);
                other.bitSet.flip(0, minDomainSize);
                this.bitSet.or(other.bitSet);
                other.bitSet.flip(0, minDomainSize);
                if (otherDomainSize < domainSize) {
                    this.bitSet.set(otherDomainSize, domainSize);
                } else {
                    this.bitSet.clear(domainSize, otherDomainSize);
                }
            }
        } else {
            super.orNot(indices);
        }
        assert (this.checkConsistency());
    }

    @Override
    public void set(int index) {
        assert (this.checkConsistency());
        this.checkInDomain(index);
        this.bitSet.set(index, !this.complement);
        assert (this.checkConsistency());
    }

    @Override
    public void set(int index, boolean value) {
        assert (this.checkConsistency());
        this.checkInDomain(index);
        this.bitSet.set(index, value ^ this.complement);
        assert (this.checkConsistency());
    }

    @Override
    public void set(int from, int to) {
        assert (this.checkConsistency());
        this.checkInDomain(from, to);
        if (this.complement) {
            this.bitSet.clear(from, to);
        } else {
            this.bitSet.set(from, to);
        }
        assert (this.checkConsistency());
    }

    public int size() {
        assert (this.checkConsistency());
        int bitSetCardinality = this.bitSet.cardinality();
        return this.complement ? this.domainSize() - bitSetCardinality : bitSetCardinality;
    }

    @Override
    public void xor(IntCollection indices) {
        assert (this.checkConsistency());
        if (indices.isEmpty()) {
            return;
        }
        if (indices instanceof SimpleBoundedNatBitSet) {
            SimpleBoundedNatBitSet other = (SimpleBoundedNatBitSet)indices;
            int otherDomainSize = other.domainSize();
            this.checkInDomain(otherDomainSize - 1);
            this.bitSet.xor(other.bitSet);
            if (other.complement) {
                this.bitSet.flip(0, otherDomainSize);
            }
        } else {
            super.xor(indices);
        }
        assert (this.checkConsistency());
    }
}

