/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.edge;

import java.util.BitSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import javax.annotation.Nonnegative;
import javax.annotation.concurrent.Immutable;
import owl.automaton.edge.Edge;

@Immutable
final class EdgeLong<S>
implements Edge<S> {
    private final long store;
    private final S successor;

    private EdgeLong(S successor, long store) {
        this.store = store;
        this.successor = Objects.requireNonNull(successor);
    }

    EdgeLong(S successor, BitSet bitSet) {
        assert (bitSet.length() <= 64 && bitSet.cardinality() > 1);
        long store = 0L;
        for (int i = 0; i < 64; ++i) {
            if (!bitSet.get(i)) continue;
            store |= 1L << i;
        }
        this.store = store;
        this.successor = successor;
        assert (this.store != 0L);
    }

    @Override
    public PrimitiveIterator.OfInt acceptanceSetIterator() {
        return new LongBitIterator(this.store);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EdgeLong)) {
            return false;
        }
        EdgeLong other = (EdgeLong)o;
        return this.store == other.store && Objects.equals(this.successor, other.successor);
    }

    @Override
    public S successor() {
        return this.successor;
    }

    @Override
    public boolean hasAcceptanceSets() {
        assert (this.store != 0L);
        return true;
    }

    public int hashCode() {
        return 31 * (int)(this.store ^ this.store >>> 32) + this.successor.hashCode();
    }

    @Override
    public boolean inSet(@Nonnegative int i) {
        Objects.checkIndex(i, Integer.MAX_VALUE);
        return i < 64 && (this.store >>> i & 1L) != 0L;
    }

    @Override
    public int largestAcceptanceSet() {
        return 63 - Long.numberOfLeadingZeros(this.store);
    }

    @Override
    public int smallestAcceptanceSet() {
        return Long.numberOfTrailingZeros(this.store);
    }

    public String toString() {
        PrimitiveIterator.OfInt acceptanceSetIterator = this.acceptanceSetIterator();
        StringBuilder builder = new StringBuilder(10);
        builder.append(acceptanceSetIterator.nextInt());
        acceptanceSetIterator.forEachRemaining(x -> builder.append(", ").append(x));
        return "-> " + this.successor + " {" + builder + "}";
    }

    @Override
    public <T> EdgeLong<T> withSuccessor(T successor) {
        return new EdgeLong<T>(successor, this.store);
    }

    private static final class LongBitIterator
    implements PrimitiveIterator.OfInt {
        private long store;

        LongBitIterator(long store) {
            this.store = store;
        }

        @Override
        public boolean hasNext() {
            return this.store != 0L;
        }

        @Override
        public int nextInt() {
            int i = Long.numberOfTrailingZeros(this.store);
            if (i == 64) {
                throw new NoSuchElementException();
            }
            this.store ^= 1L << i;
            return i;
        }
    }
}

