/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.minimizations;

import de.tum.in.naturals.Indices;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Set;
import owl.automaton.MutableAutomaton;
import owl.automaton.algorithms.SccDecomposition;
import owl.automaton.edge.Edge;

public final class GenericMinimizations {
    private GenericMinimizations() {
    }

    public static <S> void removeTransientAcceptance(MutableAutomaton<S, ?> automaton) {
        Object2IntOpenHashMap stateToSccMap = new Object2IntOpenHashMap(automaton.size());
        stateToSccMap.defaultReturnValue(-1);
        Indices.forEachIndexed(SccDecomposition.computeSccs(automaton, true), (arg_0, arg_1) -> GenericMinimizations.lambda$removeTransientAcceptance$1((Object2IntMap)stateToSccMap, arg_0, arg_1));
        automaton.updateEdges((arg_0, arg_1) -> GenericMinimizations.lambda$removeTransientAcceptance$2((Object2IntMap)stateToSccMap, arg_0, arg_1));
        automaton.trim();
    }

    private static /* synthetic */ Edge lambda$removeTransientAcceptance$2(Object2IntMap stateToSccMap, Object state, Edge edge) {
        int sccIndex = stateToSccMap.getInt(state);
        Object successor = edge.successor();
        int successorSccIndex = stateToSccMap.getInt(successor);
        assert (sccIndex != -1);
        assert (successorSccIndex != -1);
        if (sccIndex == successorSccIndex) {
            return edge;
        }
        return Edge.of(successor);
    }

    private static /* synthetic */ void lambda$removeTransientAcceptance$1(Object2IntMap stateToSccMap, int index, Set scc) {
        scc.forEach(state -> stateToSccMap.put(state, index));
    }
}

