/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.algorithms;

import java.util.EnumSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import owl.automaton.algorithms.EmptinessCheck;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.visitors.Collector;
import owl.run.DefaultEnvironment;
import owl.translations.LTL2DAFunction;

public final class LanguageAnalysis {
    private LanguageAnalysis() {
    }

    public static boolean isSatisfiable(Formula formula) {
        if (formula instanceof Disjunction) {
            return ((Disjunction)formula).children.stream().anyMatch(LanguageAnalysis::isSatisfiable);
        }
        LabelledFormula labelledFormula = LanguageAnalysis.attachDummyAlphabet(formula);
        LTL2DAFunction translation = new LTL2DAFunction(DefaultEnvironment.of(false, false), true, EnumSet.of(LTL2DAFunction.Constructions.SAFETY, LTL2DAFunction.Constructions.CO_SAFETY, LTL2DAFunction.Constructions.BUCHI, LTL2DAFunction.Constructions.CO_BUCHI, LTL2DAFunction.Constructions.RABIN));
        return !EmptinessCheck.isEmpty(translation.apply(labelledFormula));
    }

    public static boolean isUnsatisfiable(Formula formula) {
        return !LanguageAnalysis.isSatisfiable(formula);
    }

    public static boolean isUniversal(Formula formula) {
        return LanguageAnalysis.isUnsatisfiable(formula.not());
    }

    private static LabelledFormula attachDummyAlphabet(Formula formula) {
        int largestAtom = Collector.collectAtoms(formula).stream().max().orElse(0);
        return LabelledFormula.of(formula, IntStream.range(0, largestAtom + 1).mapToObj(i -> "p" + i).collect(Collectors.toUnmodifiableList()));
    }
}

