/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.visitors;

import java.util.function.Function;
import owl.ltl.Biconditional;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.visitors.PropositionalVisitor;

public final class SubstitutionVisitor
extends PropositionalVisitor<Formula> {
    private final Function<? super Formula, ? extends Formula> substitutionFunction;

    public SubstitutionVisitor(Function<? super Formula, ? extends Formula> substitutionFunction) {
        this.substitutionFunction = substitutionFunction;
    }

    @Override
    protected Formula modalOperatorAction(Formula formula) {
        return this.substitutionFunction.apply(formula);
    }

    @Override
    public Formula visit(BooleanConstant booleanConstant) {
        return booleanConstant;
    }

    @Override
    public Formula visit(Biconditional biconditional) {
        return Biconditional.of(biconditional.left.accept(this), biconditional.right.accept(this));
    }

    @Override
    public Formula visit(Conjunction conjunction) {
        return Conjunction.of(conjunction.children.stream().map(x -> x.accept(this)));
    }

    @Override
    public Formula visit(Disjunction disjunction) {
        return Disjunction.of(disjunction.children.stream().map(x -> x.accept(this)));
    }
}

