/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.nba2dpa;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import owl.automaton.Automaton;
import owl.automaton.AutomatonOperations;
import owl.automaton.AutomatonUtil;
import owl.automaton.Views;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.algorithms.LanguageAnalysis;
import owl.translations.ldba2dpa.Language;
import owl.translations.ldba2dpa.LanguageLattice;

class SetLanguageLattice<S>
implements LanguageLattice<S, Void, Set<S>> {
    final Language<Set<S>> bottom;
    final LoadingCache<Map.Entry<Set<S>, Set<S>>, Boolean> greaterOrEqualCache;
    final Language<Set<S>> top;

    SetLanguageLattice(Automaton<S, BuchiAcceptance> automaton) {
        assert (automaton.is(Automaton.Property.SEMI_DETERMINISTIC)) : "Only semi-deterministic automata supported";
        this.bottom = new SetLanguage(Set.of());
        this.top = new SetLanguage(Set.copyOf(automaton.states()));
        this.greaterOrEqualCache = CacheBuilder.newBuilder().maximumSize(500000L).expireAfterAccess(60L, TimeUnit.SECONDS).build(new Loader<S>(automaton));
    }

    @Override
    public boolean acceptsLivenessLanguage(S state) {
        return false;
    }

    @Override
    public boolean acceptsSafetyLanguage(S state) {
        return false;
    }

    @Override
    public Language<Set<S>> getBottom() {
        return this.bottom;
    }

    @Override
    public Language<Set<S>> getLanguage(S state) {
        return new SetLanguage(Set.of(state));
    }

    @Override
    public Language<Set<S>> getTop() {
        return this.top;
    }

    @Override
    public boolean isLivenessLanguage(Void annotation) {
        return false;
    }

    @Override
    public boolean isSafetyAnnotation(Void annotation) {
        return false;
    }

    private final class SetLanguage
    implements Language<Set<S>> {
        private final Set<S> set;

        SetLanguage(Set<S> set) {
            this.set = set;
        }

        @Override
        public Set<S> getT() {
            return this.set;
        }

        @Override
        public boolean greaterOrEqual(Language<Set<S>> language) {
            if (this.set.containsAll(language.getT())) {
                return true;
            }
            if (this.set.isEmpty()) {
                return false;
            }
            return (Boolean)SetLanguageLattice.this.greaterOrEqualCache.getUnchecked(new AbstractMap.SimpleEntry(this.set, language.getT()));
        }

        @Override
        public boolean isBottom() {
            return this.set.isEmpty();
        }

        @Override
        public boolean isTop() {
            return this.set.equals(SetLanguageLattice.this.top.getT());
        }

        @Override
        public Language<Set<S>> join(Language<Set<S>> language) {
            return new SetLanguage(Sets.union(this.set, language.getT()).immutableCopy());
        }
    }

    private static final class Loader<S>
    extends CacheLoader<Map.Entry<Set<S>, Set<S>>, Boolean> {
        private final Automaton<S, BuchiAcceptance> automaton;

        Loader(Automaton<S, BuchiAcceptance> automaton) {
            this.automaton = automaton;
        }

        public Boolean load(Map.Entry<Set<S>, Set<S>> entry) {
            return LanguageAnalysis.contains(this.union(entry.getValue()), this.union(entry.getKey()));
        }

        private Automaton<List<S>, BuchiAcceptance> union(Set<S> initialStates) {
            ArrayList automata = new ArrayList();
            for (S initialState : initialStates) {
                automata.add(Views.replaceInitialState(this.automaton, Set.of(initialState)));
            }
            return AutomatonUtil.cast(AutomatonOperations.union(automata), BuchiAcceptance.class);
        }
    }
}

