/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.IntVisitor;
import owl.ltl.visitors.Visitor;

public final class Biconditional
extends Formula.LogicalOperator {
    public final Formula left;
    public final Formula right;

    public Biconditional(Formula leftOperand, Formula rightOperand) {
        super(Objects.hash(Biconditional.class, leftOperand, rightOperand));
        this.left = leftOperand;
        this.right = rightOperand;
    }

    public static Formula of(Formula leftOperand, Formula rightOperand) {
        if (leftOperand.equals(BooleanConstant.TRUE)) {
            return rightOperand;
        }
        if (leftOperand.equals(BooleanConstant.FALSE)) {
            return rightOperand.not();
        }
        if (rightOperand.equals(BooleanConstant.TRUE)) {
            return leftOperand;
        }
        if (rightOperand.equals(BooleanConstant.FALSE)) {
            return leftOperand.not();
        }
        if (leftOperand.equals(rightOperand)) {
            return BooleanConstant.TRUE;
        }
        if (leftOperand.equals(rightOperand.not())) {
            return BooleanConstant.FALSE;
        }
        return new Biconditional(leftOperand, rightOperand);
    }

    @Override
    public int accept(IntVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <R, P> R accept(BinaryVisitor<P, R> visitor, P parameter) {
        return visitor.visit(this, parameter);
    }

    @Override
    public Set<Formula> children() {
        return Set.of(this.left, this.right);
    }

    @Override
    public boolean isPureEventual() {
        return false;
    }

    @Override
    public boolean isPureUniversal() {
        return false;
    }

    @Override
    public Formula not() {
        return Biconditional.of(this.left.not(), this.right);
    }

    @Override
    public Formula nnf() {
        Formula nnfLeft = this.left.nnf();
        Formula nnfRight = this.right.nnf();
        return Disjunction.of(Conjunction.of(nnfLeft, nnfRight), Conjunction.of(nnfLeft.not(), nnfRight.not()));
    }

    @Override
    public Formula substitute(Function<? super Formula.TemporalOperator, ? extends Formula> substitution) {
        return Biconditional.of(this.left.substitute(substitution), this.right.substitute(substitution));
    }

    public String toString() {
        return "(" + this.left + " <-> " + this.right + ")";
    }

    @Override
    protected int compareToImpl(Formula o) {
        Biconditional that = (Biconditional)o;
        int comparison = this.left.compareTo(that.left);
        return comparison == 0 ? this.right.compareTo(that.right) : comparison;
    }

    @Override
    protected boolean equalsImpl(Formula o) {
        Biconditional that = (Biconditional)o;
        return this.left.equals(that.left) && this.right.equals(that.right);
    }
}

