/*
 * Decompiled with CFR 0.152.
 */
package owl.run.modules;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import owl.automaton.AutomatonUtil;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.acceptance.optimizations.AcceptanceOptimizations;
import owl.automaton.transformations.RabinDegeneralization;
import owl.ltl.LabelledFormula;
import owl.ltl.rewriter.SimplifierFactory;
import owl.run.Environment;
import owl.run.modules.OutputWriter;
import owl.run.modules.Transformer;
import owl.translations.dra2dpa.IARBuilder;

public final class Transformers {
    public static final Transformer LTL_SIMPLIFIER = Transformers.fromFunction(LabelledFormula.class, x -> SimplifierFactory.apply(x, SimplifierFactory.Mode.SYNTACTIC_FIXPOINT));
    public static final Transformer MINIMIZER = new AcceptanceOptimizations.AcceptanceOptimizationTransformer();
    public static final Transformer RABIN_DEGENERALIZATION = new RabinDegeneralization();
    public static final Transformer RABIN_TO_PARITY = environment -> (input, context) -> new IARBuilder<Object>(AutomatonUtil.cast(input, RabinAcceptance.class)).build();

    private Transformers() {
    }

    public static <K, V> Transformer fromFunction(Class<K> inputClass, Function<K, V> function) {
        return environment -> Transformers.instanceFromFunction(inputClass, function);
    }

    public static <K, V> Transformer.Instance instanceFromFunction(Class<K> inputClass, Function<K, V> function) {
        return (object, context) -> {
            Preconditions.checkArgument((boolean)inputClass.isInstance(object), (String)"Expected type %s, got type %s", (Object)inputClass, object == null ? null : object.getClass());
            return function.apply(inputClass.cast(object));
        };
    }

    public static Transformer fromWriter(OutputWriter writer) {
        return environment -> (input, context) -> {
            writer.bind(context.metaWriter(), environment).write(input);
            return input;
        };
    }

    public static List<Transformer.Instance> build(List<Transformer> transformers, Environment env) {
        return transformers.stream().map(transformer -> transformer.create(env)).collect(Collectors.toUnmodifiableList());
    }

    public static abstract class SimpleTransformer
    implements Transformer.Instance,
    Transformer {
        @Override
        public Transformer.Instance create(Environment environment) {
            return this;
        }
    }
}

