/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.set;

import de.tum.in.naturals.set.NatBitSet;
import de.tum.in.naturals.set.NatBitSets;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class PowerNatBitSetIterator
implements Iterator<NatBitSet> {
    private final NatBitSet baseSet;
    private boolean hasNext = true;
    private final NatBitSet current;

    PowerNatBitSetIterator(NatBitSet baseSet) {
        assert (!baseSet.isEmpty());
        this.baseSet = baseSet;
        this.current = NatBitSets.setWithMaximalLength(baseSet.lastInt());
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public NatBitSet next() {
        if (!this.hasNext) {
            throw new NoSuchElementException("No next element");
        }
        this.hasNext = false;
        IntIterator iterator = this.baseSet.iterator();
        while (iterator.hasNext()) {
            int index = iterator.nextInt();
            if (this.current.contains(index)) {
                this.current.clear(index);
                continue;
            }
            this.hasNext = true;
            this.current.set(index);
            break;
        }
        return this.current;
    }
}

