/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.set;

import de.tum.in.naturals.BitUtil;
import de.tum.in.naturals.set.AbstractNatBitSet;
import de.tum.in.naturals.set.NatBitSetIterator;
import de.tum.in.naturals.set.NatBitSetsUtil;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.NoSuchElementException;

class LongNatBitSet
extends AbstractNatBitSet {
    private long store = 0L;

    LongNatBitSet() {
    }

    public static int maximalSize() {
        return 64;
    }

    @Override
    public void and(IntCollection indices) {
        if (indices instanceof LongNatBitSet) {
            LongNatBitSet other = (LongNatBitSet)indices;
            this.store &= other.store;
        } else {
            super.and(indices);
        }
    }

    @Override
    public void andNot(IntCollection indices) {
        if (indices instanceof LongNatBitSet) {
            LongNatBitSet other = (LongNatBitSet)indices;
            this.store &= other.store ^ 0xFFFFFFFFFFFFFFFFL;
        } else {
            super.andNot(indices);
        }
    }

    private void checkInDomain(int index) {
        NatBitSetsUtil.checkNonNegative(index);
        if (!this.inDomain(index)) {
            throw new UnsupportedOperationException(String.format("Index %d out of bounds", index));
        }
    }

    @Override
    public void clear(int index) {
        if (this.inDomain(index)) {
            this.store &= 1L << index ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    @Override
    public void clear(int from, int to) {
        NatBitSetsUtil.checkRange(from, to);
        if (!this.inDomain(from)) {
            return;
        }
        this.store &= BitUtil.mask(from, this.inDomain(to) ? to : 64) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void clear() {
        this.store = 0L;
    }

    @Override
    public void clearFrom(int from) {
        if (from < 64) {
            this.store &= BitUtil.maskTo(from);
        }
    }

    @Override
    public LongNatBitSet clone() {
        return (LongNatBitSet)super.clone();
    }

    public boolean contains(int index) {
        return this.inDomain(index) && this.containsIndex(index);
    }

    public boolean containsAll(IntCollection indices) {
        if (indices instanceof LongNatBitSet) {
            LongNatBitSet other = (LongNatBitSet)indices;
            return ((this.store ^ 0xFFFFFFFFFFFFFFFFL) & other.store) == 0L;
        }
        return super.containsAll(indices);
    }

    private boolean containsIndex(int index) {
        return (this.store & 1L << index) != 0L;
    }

    @Override
    public int firstInt() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int first = Long.numberOfTrailingZeros(this.store);
        assert (first < 64 && this.containsIndex(first));
        return first;
    }

    @Override
    public void flip(int index) {
        this.checkInDomain(index);
        this.store ^= 1L << index;
    }

    @Override
    public void flip(int from, int to) {
        NatBitSetsUtil.checkRange(from, to);
        this.checkInDomain(to);
        this.store ^= BitUtil.mask(from, to);
    }

    long getStore() {
        return this.store;
    }

    private boolean inDomain(int index) {
        return 0 <= index && index < 64;
    }

    @Override
    public boolean intersects(IntCollection indices) {
        if (indices instanceof LongNatBitSet) {
            LongNatBitSet other = (LongNatBitSet)indices;
            return (this.store & other.store) != 0L;
        }
        return super.intersects(indices);
    }

    public boolean isEmpty() {
        return this.store == 0L;
    }

    @Override
    public IntIterator iterator() {
        return new NatBitSetIterator(this);
    }

    @Override
    public int lastInt() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int last = 64 - Long.numberOfLeadingZeros(this.store) - 1;
        assert (0 <= last && this.containsIndex(last));
        return last;
    }

    @Override
    public int nextAbsentIndex(int index) {
        NatBitSetsUtil.checkNonNegative(index);
        if (this.isEmpty() || index >= 64) {
            return index;
        }
        long masked = (this.store | BitUtil.maskTo(index)) ^ 0xFFFFFFFFFFFFFFFFL;
        if (masked == 0L) {
            return 64;
        }
        int next = Long.numberOfTrailingZeros(masked);
        assert (next < 64 && !this.containsIndex(next));
        return next;
    }

    @Override
    public int nextPresentIndex(int index) {
        NatBitSetsUtil.checkNonNegative(index);
        if (index >= 64 || this.isEmpty()) {
            return -1;
        }
        long masked = this.store & (BitUtil.maskTo(index) ^ 0xFFFFFFFFFFFFFFFFL);
        if (masked == 0L) {
            return -1;
        }
        int next = Long.numberOfTrailingZeros(masked);
        assert (next < 64 && this.containsIndex(next)) : next;
        return next;
    }

    @Override
    public void or(IntCollection indices) {
        if (indices instanceof LongNatBitSet) {
            LongNatBitSet other = (LongNatBitSet)indices;
            this.store |= other.store;
        } else {
            super.or(indices);
        }
    }

    @Override
    public int previousAbsentIndex(int index) {
        NatBitSetsUtil.checkNonNegative(index);
        if (this.isEmpty() || index >= 64) {
            return index;
        }
        long mask = BitUtil.maskTo(index + 1);
        long masked = (this.store ^ 0xFFFFFFFFFFFFFFFFL) & mask;
        if (masked == 0L) {
            return -1;
        }
        int previous = 64 - Long.numberOfLeadingZeros(masked) - 1;
        assert (!this.containsIndex(previous));
        return previous;
    }

    @Override
    public int previousPresentIndex(int index) {
        NatBitSetsUtil.checkNonNegative(index);
        if (this.isEmpty()) {
            return -1;
        }
        long masked = this.store & BitUtil.maskTo(index + 1);
        if (masked == 0L) {
            return -1;
        }
        int previous = 64 - Long.numberOfLeadingZeros(masked) - 1;
        assert (this.containsIndex(previous)) : previous;
        return previous;
    }

    @Override
    public void set(int index) {
        this.checkInDomain(index);
        this.store |= 1L << index;
    }

    @Override
    public void set(int index, boolean value) {
        if (value) {
            this.set(index);
        } else {
            this.clear(index);
        }
    }

    @Override
    public void set(int from, int to) {
        NatBitSetsUtil.checkRange(from, to);
        this.checkInDomain(to);
        this.store |= BitUtil.mask(from, to);
    }

    public int size() {
        return Long.bitCount(this.store);
    }

    @Override
    public void xor(IntCollection indices) {
        if (indices instanceof LongNatBitSet) {
            LongNatBitSet other = (LongNatBitSet)indices;
            this.store ^= other.store;
        } else {
            super.xor(indices);
        }
    }
}

