/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance.optimizations;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import de.tum.in.naturals.Indices;
import de.tum.in.naturals.bitset.BitSets;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.IntConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnegative;
import owl.automaton.AutomatonUtil;
import owl.automaton.MutableAutomaton;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.optimizations.AcceptanceOptimizations;
import owl.automaton.algorithms.SccDecomposition;
import owl.automaton.edge.Edge;

public final class GeneralizedRabinAcceptanceOptimizations {
    private static final Logger logger = Logger.getLogger(GeneralizedRabinAcceptance.class.getName());

    private GeneralizedRabinAcceptanceOptimizations() {
    }

    public static <S> void removeComplementaryInfSets(MutableAutomaton<S, GeneralizedRabinAcceptance> automaton) {
        GeneralizedRabinAcceptance acceptance = (GeneralizedRabinAcceptance)automaton.acceptance();
        List pairs = acceptance.pairs().stream().filter(GeneralizedRabinAcceptance.RabinPair::hasInfSet).collect(Collectors.toList());
        ArrayList<IntAVLTreeSet> pairComplementaryInfSets = new ArrayList<IntAVLTreeSet>(pairs.size());
        for (GeneralizedRabinAcceptance.RabinPair pair : pairs) {
            IntAVLTreeSet pairInfSets = new IntAVLTreeSet();
            pair.forEachInfSet(arg_0 -> ((IntSet)pairInfSets).add(arg_0));
            pairComplementaryInfSets.add(pairInfSets);
        }
        AutomatonUtil.forEachNonTransientEdge(automaton, (state, edge) -> {
            ListIterator iterator = pairs.listIterator();
            while (iterator.hasNext()) {
                int pairIndex = iterator.nextIndex();
                GeneralizedRabinAcceptance.RabinPair pair = (GeneralizedRabinAcceptance.RabinPair)iterator.next();
                IntSet pairComplementary = (IntSet)pairComplementaryInfSets.get(pairIndex);
                assert (!pairComplementary.isEmpty());
                boolean finEdge = edge.inSet(pair.finSet());
                pairComplementary.removeIf(i -> finEdge == edge.inSet(i));
                if (!pairComplementary.isEmpty()) continue;
                iterator.remove();
                pairComplementaryInfSets.remove(pairIndex);
            }
        });
        IntAVLTreeSet indicesToRemove = new IntAVLTreeSet();
        pairComplementaryInfSets.forEach(arg_0 -> ((IntSet)indicesToRemove).addAll(arg_0));
        if (indicesToRemove.isEmpty()) {
            return;
        }
        logger.log(Level.FINER, "Removing complementary indices {0}", indicesToRemove);
        AcceptanceOptimizations.removeAndRemapIndices(automaton, (IntSet)indicesToRemove);
        automaton.acceptance(acceptance.filter(arg_0 -> ((IntSet)indicesToRemove).contains(arg_0)));
        assert (((GeneralizedRabinAcceptance)automaton.acceptance()).isWellFormedAutomaton(automaton));
    }

    public static <S> void minimizeEdgeImplications(MutableAutomaton<S, GeneralizedRabinAcceptance> automaton) {
        GeneralizedRabinAcceptance acceptance = (GeneralizedRabinAcceptance)automaton.acceptance();
        int acceptanceSets = acceptance.acceptanceSets();
        BitSet defaultConsequent = new BitSet(acceptanceSets);
        defaultConsequent.set(0, acceptanceSets);
        BitSet[] impliesMap = new BitSet[acceptanceSets];
        Arrays.setAll(impliesMap, i -> BitSets.copyOf((BitSet)defaultConsequent));
        AutomatonUtil.forEachNonTransientEdge(automaton, (state, edge) -> edge.acceptanceSetIterator().forEachRemaining(index -> {
            BitSet consequences = impliesMap[index];
            BitSets.forEach((BitSet)consequences, consequent -> {
                if (!edge.inSet(consequent)) {
                    consequences.clear(consequent);
                }
            });
        }));
        if (logger.isLoggable(Level.FINER)) {
            StringBuilder builder = new StringBuilder(30 * impliesMap.length);
            builder.append("Implication map:");
            int index = 0;
            while (index < acceptanceSets) {
                builder.append("\n  ").append(index).append(" => ");
                BitSet antecedent = impliesMap[index];
                int i2 = index++;
                BitSets.forEach((BitSet)antecedent, otherIndex -> {
                    if (i2 != otherIndex) {
                        builder.append(otherIndex).append(' ');
                    }
                });
            }
            logger.log(Level.FINER, builder.toString());
        }
        IntAVLTreeSet indicesToRemove = new IntAVLTreeSet();
        for (GeneralizedRabinAcceptance.RabinPair pair : acceptance.pairs()) {
            pair.forEachInfSet(arg_0 -> GeneralizedRabinAcceptanceOptimizations.lambda$minimizeEdgeImplications$7((IntSet)indicesToRemove, impliesMap, pair, arg_0));
        }
        logger.log(Level.FINEST, "Implication removal: {0}", indicesToRemove);
        AcceptanceOptimizations.removeAndRemapIndices(automaton, (IntSet)indicesToRemove);
        automaton.acceptance(acceptance.filter(arg_0 -> ((IntSet)indicesToRemove).contains(arg_0)));
        assert (((GeneralizedRabinAcceptance)automaton.acceptance()).isWellFormedAutomaton(automaton));
    }

    public static <S> void minimizeMergePairs(MutableAutomaton<S, GeneralizedRabinAcceptance> automaton) {
        boolean someMerge;
        List pairs = ((GeneralizedRabinAcceptance)automaton.acceptance()).pairs().stream().filter(GeneralizedRabinAcceptance.RabinPair::hasInfSet).collect(Collectors.toList());
        if (pairs.isEmpty()) {
            return;
        }
        TreeMap<GeneralizedRabinAcceptance.RabinPair, IntSet> pairActiveSccs = new TreeMap<GeneralizedRabinAcceptance.RabinPair, IntSet>();
        Indices.forEachIndexed(SccDecomposition.computeSccs(automaton, false), (sccIndex, scc) -> {
            BitSet indices = AutomatonUtil.getAcceptanceSets(automaton, scc);
            pairs.forEach(pair -> {
                if (pair.contains(indices)) {
                    pairActiveSccs.computeIfAbsent((GeneralizedRabinAcceptance.RabinPair)pair, k -> new IntOpenHashSet()).add(sccIndex);
                }
            });
        });
        ArrayList<MergeClass> mergeClasses = new ArrayList<MergeClass>(pairs.size());
        pairActiveSccs.forEach((pair, activeSccs) -> mergeClasses.add(new MergeClass((GeneralizedRabinAcceptance.RabinPair)pair, (IntSet)activeSccs)));
        block0: do {
            someMerge = false;
            for (MergeClass mergeClass2 : mergeClasses) {
                someMerge = mergeClasses.removeIf(mergeClass2::tryMerge);
                if (!someMerge) continue;
                continue block0;
            }
        } while (someMerge);
        Int2ObjectAVLTreeMap remapping = new Int2ObjectAVLTreeMap();
        mergeClasses.forEach(arg_0 -> GeneralizedRabinAcceptanceOptimizations.lambda$minimizeMergePairs$13((Int2ObjectMap)remapping, arg_0));
        if (logger.isLoggable(Level.FINER)) {
            List trueMerges = mergeClasses.stream().filter(mergeClass -> mergeClass.pairs.size() > 1).collect(Collectors.toList());
            logger.log(Level.FINER, "Merge classes {0}, indices {1}", new Object[]{trueMerges, remapping});
        }
        automaton.updateEdges((arg_0, arg_1) -> GeneralizedRabinAcceptanceOptimizations.lambda$minimizeMergePairs$16((Int2ObjectMap)remapping, arg_0, arg_1));
        IntAVLTreeSet indicesToRemove = new IntAVLTreeSet((IntCollection)remapping.keySet());
        remapping.values().forEach(arg_0 -> ((IntSet)indicesToRemove).removeAll(arg_0));
        AcceptanceOptimizations.removeAndRemapIndices(automaton, (IntSet)indicesToRemove);
        automaton.acceptance(((GeneralizedRabinAcceptance)automaton.acceptance()).filter(arg_0 -> ((IntSet)indicesToRemove).contains(arg_0)));
        assert (((GeneralizedRabinAcceptance)automaton.acceptance()).isWellFormedAutomaton(automaton));
    }

    public static <S> void minimizeOverlap(MutableAutomaton<S, GeneralizedRabinAcceptance> automaton) {
        GeneralizedRabinAcceptance acceptance = (GeneralizedRabinAcceptance)automaton.acceptance();
        List pairs = acceptance.pairs().stream().filter(GeneralizedRabinAcceptance.RabinPair::hasInfSet).collect(Collectors.toUnmodifiableList());
        if (pairs.isEmpty()) {
            return;
        }
        automaton.updateEdges((state, edge) -> {
            if (!edge.hasAcceptanceSets()) {
                return edge;
            }
            int overlapIndex = -1;
            for (int index = 0; index < pairs.size(); ++index) {
                GeneralizedRabinAcceptance.RabinPair pair = (GeneralizedRabinAcceptance.RabinPair)pairs.get(index);
                if (!edge.inSet(pair.finSet()) || !pair.containsInfinite((Edge<?>)edge)) continue;
                overlapIndex = index;
                break;
            }
            if (overlapIndex == -1) {
                return edge;
            }
            BitSet modifiedAcceptance = new BitSet(edge.largestAcceptanceSet());
            edge.acceptanceSetIterator().forEachRemaining(modifiedAcceptance::set);
            ((GeneralizedRabinAcceptance.RabinPair)pairs.get(overlapIndex)).forEachInfSet(modifiedAcceptance::clear);
            for (int index = overlapIndex + 1; index < pairs.size(); ++index) {
                GeneralizedRabinAcceptance.RabinPair pair = (GeneralizedRabinAcceptance.RabinPair)pairs.get(index);
                if (!edge.inSet(pair.finSet()) || !pair.containsInfinite((Edge<?>)edge)) continue;
                pair.forEachInfSet(modifiedAcceptance::clear);
            }
            return Edge.of(edge.successor(), modifiedAcceptance);
        });
    }

    public static <S> void minimizePairImplications(MutableAutomaton<S, GeneralizedRabinAcceptance> automaton) {
        int sccIndex;
        StringBuilder logBuilder;
        GeneralizedRabinAcceptance acceptance = (GeneralizedRabinAcceptance)automaton.acceptance();
        int acceptanceSets = acceptance.acceptanceSets();
        ArrayList<GeneralizedRabinAcceptance.RabinPair> pairs = new ArrayList<GeneralizedRabinAcceptance.RabinPair>(acceptance.pairs());
        List<Set<S>> sccs = SccDecomposition.computeSccs(automaton, false);
        ArrayList<TreeMultimap> sccImplicationList = new ArrayList<TreeMultimap>(sccs.size());
        StringBuilder stringBuilder = logBuilder = logger.isLoggable(Level.FINEST) ? new StringBuilder(200 + sccs.size() * 50) : null;
        if (logBuilder != null) {
            logBuilder.append("Implications:");
        }
        BitSet defaultConsequent = new BitSet(acceptanceSets);
        defaultConsequent.set(0, acceptanceSets);
        BitSet[] impliesMap = new BitSet[acceptanceSets];
        for (int sccIndex2 = 0; sccIndex2 < sccs.size(); ++sccIndex2) {
            Object state2;
            Set<S> scc = sccs.get(sccIndex2);
            Arrays.setAll(impliesMap, i -> BitSets.copyOf((BitSet)defaultConsequent));
            for (Object state2 : scc) {
                for (Edge edge : automaton.edges(state2)) {
                    if (!scc.contains(edge.successor())) continue;
                    edge.acceptanceSetIterator().forEachRemaining(index -> BitSets.forEach((BitSet)impliesMap[index], consequent -> {
                        if (!edge.inSet(consequent)) {
                            impliesMap[index].clear(consequent);
                        }
                    }));
                }
            }
            TreeMultimap sccImplications = TreeMultimap.create();
            state2 = pairs.iterator();
            while (state2.hasNext()) {
                Edge edge;
                GeneralizedRabinAcceptance.RabinPair antecedent2 = (GeneralizedRabinAcceptance.RabinPair)state2.next();
                edge = pairs.iterator();
                while (edge.hasNext()) {
                    GeneralizedRabinAcceptance.RabinPair consequent2 = (GeneralizedRabinAcceptance.RabinPair)edge.next();
                    if (antecedent2.equals(consequent2) || !impliesMap[consequent2.finSet()].get(antecedent2.finSet())) continue;
                    boolean infImplied = true;
                    if (consequent2.hasInfSet()) {
                        int consequentInfIndices = consequent2.infSetCount();
                        int antecedentInfIndices = antecedent2.infSetCount();
                        for (int consequentNumber = 0; consequentNumber < consequentInfIndices; ++consequentNumber) {
                            boolean foundImplication = false;
                            int consequentIndex = consequent2.infSet(consequentNumber);
                            for (int antecedentNumber = 0; antecedentNumber < antecedentInfIndices; ++antecedentNumber) {
                                int antecedentIndex = antecedent2.infSet(antecedentNumber);
                                if (!impliesMap[antecedentIndex].get(consequentIndex)) continue;
                                foundImplication = true;
                                break;
                            }
                            if (foundImplication) continue;
                            infImplied = false;
                            break;
                        }
                    } else {
                        boolean bl = infImplied = !antecedent2.hasInfSet();
                    }
                    if (!infImplied) continue;
                    sccImplications.put((Object)antecedent2, (Object)consequent2);
                }
            }
            sccImplicationList.add(sccImplications);
            if (logBuilder == null) continue;
            logBuilder.append("\n ").append(sccIndex2).append(" - ").append(sccs.get(sccIndex2)).append("\n  Indices:");
            IntIterators.fromTo((int)0, (int)acceptanceSets).forEachRemaining(index -> {
                logBuilder.append("\n   ").append(index).append(" => ");
                BitSet antecedent = impliesMap[index];
                IntConsumer consumer = otherIndex -> {
                    if (index != otherIndex) {
                        logBuilder.append(otherIndex).append(' ');
                    }
                };
                BitSets.forEach((BitSet)antecedent, (IntConsumer)consumer);
            });
            logBuilder.append("\n  Pairs:");
            if (sccImplications.isEmpty()) {
                logBuilder.append("\n   ").append("None");
                continue;
            }
            sccImplications.asMap().forEach((pair, consequences) -> logBuilder.append("\n   ").append(pair).append(" => ").append(consequences));
        }
        HashSet toRemove = new HashSet();
        pairs.stream().filter(pair -> sccImplicationList.stream().allMatch(sccImplications -> sccImplications.get(pair).stream().anyMatch(consequent -> !toRemove.contains(consequent)))).forEach(toRemove::add);
        ArrayList pairsToRemoveInSccs = new ArrayList(sccs.size());
        for (sccIndex = 0; sccIndex < sccs.size(); ++sccIndex) {
            Multimap sccImplications = (Multimap)sccImplicationList.get(sccIndex);
            HashSet toRemoveInScc = new HashSet(sccImplications.keySet().size());
            sccImplications.forEach((antecedent, consequent) -> {
                if (!(toRemove.contains(antecedent) || toRemove.contains(consequent) || toRemoveInScc.contains(consequent))) {
                    toRemoveInScc.add(antecedent);
                }
            });
            pairsToRemoveInSccs.add(toRemoveInScc);
        }
        if (logBuilder != null) {
            logBuilder.append("\nRemovals:\n  Global: ").append(toRemove);
            for (sccIndex = 0; sccIndex < sccs.size(); ++sccIndex) {
                logBuilder.append("\n  ").append(sccIndex).append(": ").append(pairsToRemoveInSccs.get(sccIndex));
            }
            logger.log(Level.FINEST, logBuilder.toString());
        }
        for (sccIndex = 0; sccIndex < sccs.size(); ++sccIndex) {
            Set<S> scc = sccs.get(sccIndex);
            Set pairsToRemoveInScc = (Set)pairsToRemoveInSccs.get(sccIndex);
            if (pairsToRemoveInScc.isEmpty()) continue;
            BitSet indicesToRemoveInScc = new BitSet();
            pairsToRemoveInScc.forEach(pair -> pair.forEachInfSet(indicesToRemoveInScc::set));
            AcceptanceOptimizations.removeIndices(automaton, scc, indicesToRemoveInScc);
        }
        IntAVLTreeSet indicesToRemove = new IntAVLTreeSet();
        toRemove.forEach(arg_0 -> GeneralizedRabinAcceptanceOptimizations.lambda$minimizePairImplications$29((IntSet)indicesToRemove, arg_0));
        AcceptanceOptimizations.removeAndRemapIndices(automaton, (IntSet)indicesToRemove);
        automaton.acceptance(acceptance.filter(arg_0 -> ((IntSet)indicesToRemove).contains(arg_0)));
        assert (((GeneralizedRabinAcceptance)automaton.acceptance()).isWellFormedAutomaton(automaton));
    }

    public static <S> void minimizeSccIrrelevant(MutableAutomaton<S, GeneralizedRabinAcceptance> automaton) {
        Object indicesToRemove;
        GeneralizedRabinAcceptance acceptance = (GeneralizedRabinAcceptance)automaton.acceptance();
        List finOnlyPairs = acceptance.pairs().stream().filter(x -> !x.hasInfSet()).collect(Collectors.toUnmodifiableList());
        for (Set scc : SccDecomposition.computeSccs(automaton, false)) {
            BitSet indicesInScc = AutomatonUtil.getAcceptanceSets(automaton, scc);
            indicesToRemove = new BitSet();
            for (GeneralizedRabinAcceptance.RabinPair pair2 : acceptance.pairs()) {
                boolean finOccurring = indicesInScc.get(pair2.finSet());
                boolean infOccurring = false;
                boolean impossibleIndexFound = false;
                for (int number = 0; !(number >= pair2.infSetCount() || impossibleIndexFound && infOccurring); ++number) {
                    if (indicesInScc.get(pair2.infSet(number))) {
                        infOccurring = true;
                        continue;
                    }
                    impossibleIndexFound = true;
                }
                if (!infOccurring && !finOccurring) continue;
                if (impossibleIndexFound) {
                    pair2.forEachIndex(((BitSet)indicesToRemove)::set);
                }
                if (finOccurring) continue;
                ((BitSet)indicesToRemove).set(pair2.finSet());
            }
            finOnlyPairs.stream().filter(pair -> !indicesInScc.get(pair.finSet())).findAny().ifPresent(pair -> {
                indicesInScc.clear(pair.finSet());
                AcceptanceOptimizations.removeIndices(automaton, scc, indicesInScc);
            });
            AcceptanceOptimizations.removeIndices(automaton, scc, (BitSet)indicesToRemove);
        }
        IntOpenHashSet indicesOnEveryEdge = new IntOpenHashSet((Iterator)IntStream.range(0, acceptance.acceptanceSets()).iterator());
        IntOpenHashSet occurringIndices = new IntOpenHashSet();
        AutomatonUtil.forEachNonTransientEdge(automaton, (arg_0, arg_1) -> GeneralizedRabinAcceptanceOptimizations.lambda$minimizeSccIrrelevant$34((IntSet)occurringIndices, (IntSet)indicesOnEveryEdge, arg_0, arg_1));
        HashSet<GeneralizedRabinAcceptance.RabinPair> impossiblePairs = new HashSet<GeneralizedRabinAcceptance.RabinPair>();
        for (GeneralizedRabinAcceptance.RabinPair pair3 : acceptance.pairs()) {
            if (indicesOnEveryEdge.contains(pair3.finSet())) {
                impossiblePairs.add(pair3);
                continue;
            }
            boolean anyInfOccurring = false;
            boolean impossibleInfFound = false;
            for (int i = 0; !(i >= pair3.infSetCount() || anyInfOccurring && impossibleInfFound); ++i) {
                int infiniteIndex = pair3.infSet(i);
                if (occurringIndices.contains(infiniteIndex)) {
                    anyInfOccurring = true;
                    continue;
                }
                impossibleInfFound = true;
                impossiblePairs.add(pair3);
            }
        }
        logger.log(Level.FINER, "Removing impossible pairs {0}", new Object[]{impossiblePairs});
        indicesToRemove = new IntOpenHashSet();
        impossiblePairs.forEach(arg_0 -> GeneralizedRabinAcceptanceOptimizations.lambda$minimizeSccIrrelevant$35((IntSet)indicesToRemove, arg_0));
        AcceptanceOptimizations.removeAndRemapIndices(automaton, (IntSet)indicesToRemove);
        automaton.updateAcceptance(arg_0 -> GeneralizedRabinAcceptanceOptimizations.lambda$minimizeSccIrrelevant$36((IntSet)indicesToRemove, arg_0));
        assert (((GeneralizedRabinAcceptance)automaton.acceptance()).isWellFormedAutomaton(automaton));
    }

    public static <S> void mergeBuchiTypePairs(MutableAutomaton<S, GeneralizedRabinAcceptance> automaton) {
        BitSet usedIndices = AutomatonUtil.getAcceptanceSets(automaton);
        List buchiTypePairs = ((GeneralizedRabinAcceptance)automaton.acceptance()).pairs().stream().filter(x -> x.infSetCount() == 1 && !usedIndices.get(x.finSet())).collect(Collectors.toList());
        if (buchiTypePairs.size() < 2) {
            return;
        }
        Iterator pairsIterator = buchiTypePairs.iterator();
        GeneralizedRabinAcceptance.RabinPair representativePair = (GeneralizedRabinAcceptance.RabinPair)pairsIterator.next();
        BitSet indicesToRemoveFin = new BitSet();
        BitSet indicesToRemoveInf = new BitSet();
        pairsIterator.forEachRemaining(x -> {
            indicesToRemoveFin.set(x.finSet());
            indicesToRemoveInf.set(x.infSet());
        });
        automaton.updateEdges((state, edge) -> edge.withAcceptance(x -> {
            Preconditions.checkState((!indicesToRemoveFin.get(x) ? 1 : 0) != 0);
            return indicesToRemoveInf.get(x) ? representativePair.infSet() : x;
        }));
        IntOpenHashSet indicesToRemove = new IntOpenHashSet();
        indicesToRemoveFin.stream().forEach(arg_0 -> ((IntOpenHashSet)indicesToRemove).add(arg_0));
        indicesToRemoveInf.stream().forEach(arg_0 -> ((IntOpenHashSet)indicesToRemove).add(arg_0));
        AcceptanceOptimizations.removeAndRemapIndices(automaton, (IntSet)indicesToRemove);
        automaton.updateAcceptance(x -> x.filter(arg_0 -> ((IntOpenHashSet)indicesToRemove).contains(arg_0)));
        assert (((GeneralizedRabinAcceptance)automaton.acceptance()).isWellFormedAutomaton(automaton));
    }

    private static /* synthetic */ GeneralizedRabinAcceptance lambda$minimizeSccIrrelevant$36(IntSet indicesToRemove, GeneralizedRabinAcceptance x) {
        return x.filter(arg_0 -> ((IntSet)indicesToRemove).contains(arg_0));
    }

    private static /* synthetic */ void lambda$minimizeSccIrrelevant$35(IntSet indicesToRemove, GeneralizedRabinAcceptance.RabinPair pair) {
        pair.forEachIndex(arg_0 -> ((IntSet)indicesToRemove).add(arg_0));
    }

    private static /* synthetic */ void lambda$minimizeSccIrrelevant$34(IntSet occurringIndices, IntSet indicesOnEveryEdge, Object state, Edge edge) {
        edge.acceptanceSetIterator().forEachRemaining(arg_0 -> ((IntSet)occurringIndices).add(arg_0));
        indicesOnEveryEdge.removeIf(index -> !edge.inSet(index));
    }

    private static /* synthetic */ void lambda$minimizePairImplications$29(IntSet indicesToRemove, GeneralizedRabinAcceptance.RabinPair pair) {
        pair.forEachIndex(arg_0 -> ((IntSet)indicesToRemove).add(arg_0));
    }

    private static /* synthetic */ Edge lambda$minimizeMergePairs$16(Int2ObjectMap remapping, Object state, Edge edge) {
        BitSet newAcceptance = new BitSet();
        edge.acceptanceSetIterator().forEachRemaining(index -> {
            IntSet indexRemapping = (IntSet)remapping.get(index);
            if (indexRemapping == null) {
                newAcceptance.set(index);
            } else {
                indexRemapping.forEach(newAcceptance::set);
            }
        });
        return Edge.of(edge.successor(), newAcceptance);
    }

    private static /* synthetic */ void lambda$minimizeMergePairs$13(Int2ObjectMap remapping, MergeClass mergeClass) {
        if (mergeClass.pairs.size() == 1) {
            ((GeneralizedRabinAcceptance.RabinPair)Iterables.getOnlyElement(mergeClass.pairs)).forEachIndex(index -> remapping.put(index, (Object)IntSets.singleton((int)index)));
        }
        int representativeFin = mergeClass.representativeFin;
        IntSet representativeInf = mergeClass.representativeInf;
        int representativeInfCount = representativeInf.size();
        for (GeneralizedRabinAcceptance.RabinPair mergedPair : mergeClass.pairs) {
            assert (mergedPair.hasInfSet());
            remapping.put(mergedPair.finSet(), (Object)IntSets.singleton((int)representativeFin));
            int mergedInfiniteCount = mergedPair.infSetCount();
            assert (mergedInfiniteCount <= representativeInfCount);
            IntIterator infIterator = representativeInf.iterator();
            for (int infiniteNumber = 0; infiniteNumber < mergedInfiniteCount - 1; ++infiniteNumber) {
                remapping.put(mergedPair.infSet(infiniteNumber), (Object)IntSets.singleton((int)infIterator.nextInt()));
            }
            int finalIndex = mergedPair.infSet(mergedInfiniteCount - 1);
            IntAVLTreeSet finalSet = new IntAVLTreeSet();
            infIterator.forEachRemaining(arg_0 -> ((IntSet)finalSet).add(arg_0));
            assert (!finalSet.isEmpty());
            remapping.put(finalIndex, (Object)finalSet);
        }
    }

    private static /* synthetic */ void lambda$minimizeEdgeImplications$7(IntSet indicesToRemove, BitSet[] impliesMap, GeneralizedRabinAcceptance.RabinPair pair, int index) {
        if (indicesToRemove.contains(index)) {
            return;
        }
        BitSet consequences = impliesMap[index];
        int consequenceIndex = consequences.nextSetBit(0);
        while (consequenceIndex >= 0) {
            if (consequenceIndex != index && !indicesToRemove.contains(consequenceIndex) && pair.isInfinite(consequenceIndex)) {
                indicesToRemove.add(consequenceIndex);
            }
            consequenceIndex = consequences.nextSetBit(consequenceIndex + 1);
        }
    }

    private static final class MergeClass {
        final IntSet activeSccIndices;
        final SortedSet<GeneralizedRabinAcceptance.RabinPair> pairs = new TreeSet<GeneralizedRabinAcceptance.RabinPair>();
        @Nonnegative
        final int representativeFin;
        final IntSet representativeInf;

        MergeClass(GeneralizedRabinAcceptance.RabinPair pair, IntSet activeIndices) {
            this.pairs.add(pair);
            this.activeSccIndices = new IntAVLTreeSet((IntCollection)activeIndices);
            this.representativeFin = pair.finSet();
            this.representativeInf = new IntAVLTreeSet();
            pair.forEachInfSet(arg_0 -> ((IntSet)this.representativeInf).add(arg_0));
        }

        public String toString() {
            return String.format("%s (%s)", this.pairs, this.activeSccIndices);
        }

        boolean tryMerge(MergeClass other) {
            if (this.equals(other)) {
                return false;
            }
            assert (Sets.intersection(this.pairs, other.pairs).isEmpty());
            if (IntIterators.any((IntIterator)this.activeSccIndices.iterator(), arg_0 -> ((IntSet)other.activeSccIndices).contains(arg_0))) {
                return false;
            }
            if (this.representativeInf.size() < other.representativeInf.size()) {
                return false;
            }
            assert (other.pairs.stream().allMatch(pair -> pair.infSetCount() <= this.representativeInf.size()));
            this.activeSccIndices.addAll((IntCollection)other.activeSccIndices);
            this.pairs.addAll(other.pairs);
            return true;
        }
    }
}

