/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.algorithms;

import java.util.BitSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import owl.automaton.AbstractCachedStatesAutomaton;
import owl.automaton.Automaton;
import owl.automaton.EdgesAutomatonMixin;
import owl.automaton.UltimatelyPeriodicWord;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.algorithms.IndexedStateTuple;
import owl.automaton.algorithms.LanguageEmptiness;
import owl.automaton.edge.Edge;
import owl.automaton.util.AnnotatedState;
import owl.factories.ValuationSetFactory;
import owl.util.annotation.HashedTuple;

public final class LanguageMembership {
    private LanguageMembership() {
    }

    public static <S, A extends OmegaAcceptance> boolean contains(Automaton<S, A> automaton, UltimatelyPeriodicWord word) {
        return !LanguageEmptiness.isEmpty(new IndexedAutomaton<S, A>(automaton, word));
    }

    private static class IndexedAutomaton<S, A extends OmegaAcceptance>
    extends AbstractCachedStatesAutomaton<IndexedState<S>, A>
    implements EdgesAutomatonMixin<IndexedState<S>, A> {
        private final Automaton<S, A> automaton;
        private final UltimatelyPeriodicWord word;

        private IndexedAutomaton(Automaton<S, A> automaton, UltimatelyPeriodicWord word) {
            this.automaton = automaton;
            this.word = word;
        }

        @Override
        public A acceptance() {
            return this.automaton.acceptance();
        }

        @Override
        public ValuationSetFactory factory() {
            return this.automaton.factory();
        }

        @Override
        public Set<IndexedState<S>> initialStates() {
            return this.automaton.initialStates().stream().map(x -> IndexedStateTuple.create(-this.word.prefix.size(), x)).collect(Collectors.toUnmodifiableSet());
        }

        @Override
        public Set<Edge<IndexedState<S>>> edges(IndexedState<S> state, BitSet valuation) {
            BitSet allowedValuation = state.index() < 0 ? this.word.prefix.get(-state.index() - 1) : this.word.period.get(state.index());
            if (!allowedValuation.equals(valuation)) {
                return Set.of();
            }
            Set<Edge<S>> edges = this.automaton.edges(state.state(), valuation);
            int nextIndex = state.index() + 1 >= this.word.period.size() ? (state.index() + 1) % this.word.period.size() : state.index() + 1;
            return edges.stream().map(x -> x.withSuccessor(IndexedState.of(nextIndex, x.successor()))).collect(Collectors.toUnmodifiableSet());
        }
    }

    @Value.Immutable
    @HashedTuple
    static abstract class IndexedState<S>
    implements AnnotatedState<S> {
        IndexedState() {
        }

        abstract int index();

        static <S> IndexedState<S> of(int index, S state) {
            return IndexedStateTuple.create(index, state);
        }
    }
}

