/*
 * Decompiled with CFR 0.152.
 */
package owl.factories.jbdd;

import de.tum.in.jbdd.Bdd;
import de.tum.in.naturals.bitset.BitSets;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import jhoafparser.ast.Atom;
import jhoafparser.ast.AtomLabel;
import jhoafparser.ast.BooleanExpression;
import owl.collections.ValuationSet;
import owl.collections.ValuationTree;
import owl.factories.ValuationSetFactory;
import owl.factories.jbdd.GcManagedFactory;

final class ValuationFactory
extends GcManagedFactory<BddValuationSet>
implements ValuationSetFactory {
    private static final BooleanExpression<AtomLabel> FALSE = new BooleanExpression(false);
    private static final BooleanExpression<AtomLabel> TRUE = new BooleanExpression(true);
    private static final BitSet EMPTY = new BitSet(0);
    private final List<String> alphabet;
    private final BddValuationSet empty;
    private final BddValuationSet universe;

    ValuationFactory(Bdd factory, List<String> alphabet) {
        super(factory);
        this.alphabet = List.copyOf(alphabet);
        factory.createVariables(this.alphabet.size());
        assert (factory.numberOfVariables() == this.alphabet.size());
        this.universe = this.create(factory.getTrueNode());
        this.empty = this.create(factory.getFalseNode());
    }

    @Override
    public List<String> alphabet() {
        return this.alphabet;
    }

    @Override
    public ValuationSet empty() {
        return this.empty;
    }

    @Override
    public ValuationSet of(int literal) {
        return this.create(this.factory.getVariableNode(literal));
    }

    @Override
    public ValuationSet of(BitSet valuation, BitSet restrictedAlphabet) {
        return this.create(this.createBdd(valuation, restrictedAlphabet));
    }

    @Override
    public ValuationSet of(BitSet valuation) {
        return this.create(this.createBdd(valuation));
    }

    @Override
    public ValuationSet universe() {
        return this.universe;
    }

    @Override
    public ValuationSet complement(ValuationSet set) {
        return this.create(this.factory.not(this.getBdd(set)));
    }

    @Override
    public BitSet any(ValuationSet set) {
        return this.factory.getSatisfyingAssignment(this.getBdd(set));
    }

    @Override
    public boolean contains(ValuationSet set, BitSet valuation) {
        return this.factory.evaluate(this.getBdd(set), valuation);
    }

    @Override
    public boolean contains(ValuationSet set, ValuationSet other) {
        return this.factory.implies(this.getBdd(set), this.getBdd(other));
    }

    @Override
    public void forEach(ValuationSet set, Consumer<? super BitSet> action) {
        int variables = this.factory.numberOfVariables();
        this.factory.forEachMinimalSolution(this.getBdd(set), (solution, solutionSupport) -> {
            solutionSupport.flip(0, variables);
            BitSets.powerSet((BitSet)solutionSupport).forEach((? super T nonRelevantValuation) -> {
                nonRelevantValuation.or((BitSet)solution);
                action.accept((BitSet)nonRelevantValuation);
                nonRelevantValuation.and((BitSet)solutionSupport);
            });
            solutionSupport.flip(0, variables);
        });
    }

    @Override
    public void forEach(ValuationSet set, BitSet restriction, Consumer<? super BitSet> action) {
        int variables = this.factory.numberOfVariables();
        BitSet restrictedVariables = BitSets.copyOf((BitSet)restriction);
        restrictedVariables.flip(0, variables);
        int restrict = this.factory.restrict(this.getBdd(set), restrictedVariables, EMPTY);
        this.factory.forEachMinimalSolution(restrict, (solution, solutionSupport) -> {
            assert (!solution.intersects(restrictedVariables));
            solutionSupport.xor(restriction);
            BitSets.powerSet((BitSet)solutionSupport).forEach((? super T nonRelevantValuation) -> {
                solution.or((BitSet)nonRelevantValuation);
                action.accept((BitSet)solution);
                solution.andNot((BitSet)nonRelevantValuation);
            });
            solutionSupport.xor(restriction);
        });
    }

    @Override
    public boolean intersects(ValuationSet set, ValuationSet other) {
        return !this.factory.implies(this.getBdd(set), this.factory.not(this.getBdd(other)));
    }

    @Override
    public ValuationSet intersection(ValuationSet set1, ValuationSet set2) {
        return this.create(this.factory.and(this.getBdd(set1), this.getBdd(set2)));
    }

    @Override
    public ValuationSet intersection(Iterator<ValuationSet> sets) {
        int bdd = this.factory.getTrueNode();
        while (sets.hasNext()) {
            bdd = this.factory.and(bdd, this.getBdd(sets.next()));
        }
        return this.create(bdd);
    }

    @Override
    public ValuationSet union(ValuationSet set1, ValuationSet set2) {
        return this.create(this.factory.or(this.getBdd(set1), this.getBdd(set2)));
    }

    @Override
    public ValuationSet union(Iterator<ValuationSet> sets) {
        int bdd = this.factory.getFalseNode();
        while (sets.hasNext()) {
            bdd = this.factory.or(bdd, this.getBdd(sets.next()));
        }
        return this.create(bdd);
    }

    @Override
    public ValuationSet minus(ValuationSet set1, ValuationSet set2) {
        return this.create(this.factory.notAnd(this.getBdd(set1), this.getBdd(set2)));
    }

    @Override
    public BooleanExpression<AtomLabel> toExpression(ValuationSet set) {
        return this.toExpression(this.getBdd(set));
    }

    @Override
    public <S> ValuationTree<S> inverse(Map<S, ValuationSet> sets) {
        if (sets.isEmpty()) {
            return ValuationTree.of(List.of());
        }
        int offset = this.alphabet.size();
        int requiredVariables = sets.size() - (this.factory.numberOfVariables() - offset);
        if (requiredVariables > 0) {
            this.factory.createVariables(requiredVariables);
        }
        int bdd = this.factory.getTrueNode();
        List list = List.copyOf(sets.entrySet());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Map.Entry<S, ValuationSet> entry = list.get(i2);
            int relation = this.factory.reference(this.factory.equivalence(this.factory.getVariableNode(offset + i2), this.getBdd(entry.getValue())));
            bdd = this.factory.consume(this.factory.and(bdd, relation), bdd, relation);
        }
        ValuationTree<Object> result = this.inverseMemoized(bdd, new HashMap<Integer, ValuationTree<S>>(), i -> ((Map.Entry)list.get(i - offset)).getKey(), offset + list.size());
        this.factory.dereference(bdd);
        return result;
    }

    private <S> ValuationTree<S> inverseMemoized(int bdd, Map<Integer, ValuationTree<S>> cache, IntFunction<S> mapper, int maxSize) {
        assert (bdd != this.factory.getTrueNode());
        assert (bdd != this.factory.getFalseNode());
        ValuationTree<Object> tree = cache.get(bdd);
        if (tree != null) {
            return tree;
        }
        int variable = this.factory.getVariable(bdd);
        tree = variable < this.alphabetSize() ? ValuationTree.of(variable, this.inverseMemoized(this.factory.getHigh(bdd), cache, mapper, maxSize), this.inverseMemoized(this.factory.getLow(bdd), cache, mapper, maxSize)) : ValuationTree.of(this.getOnlySatisfyingAssignment(bdd, maxSize - 1).stream().mapToObj(mapper).collect(Collectors.toUnmodifiableSet()));
        cache.put(bdd, tree);
        return tree;
    }

    private BitSet getOnlySatisfyingAssignment(int bdd, int largestVariable) {
        assert (bdd != this.factory.getTrueNode());
        assert (bdd != this.factory.getFalseNode());
        int variable = this.factory.getVariable(bdd);
        if (variable < largestVariable) {
            int high = this.factory.getHigh(bdd);
            if (high == this.factory.getFalseNode()) {
                return this.getOnlySatisfyingAssignment(this.factory.getLow(bdd), largestVariable);
            }
            assert (this.factory.getLow(bdd) == this.factory.getFalseNode());
            assert (high != this.factory.getTrueNode());
            BitSet assignment = this.getOnlySatisfyingAssignment(high, largestVariable);
            assignment.set(variable);
            return assignment;
        }
        assert (variable == largestVariable);
        assert (this.factory.getTrueNode() == this.factory.getLow(bdd) || this.factory.getFalseNode() == this.factory.getLow(bdd));
        assert (this.factory.getTrueNode() == this.factory.getHigh(bdd) || this.factory.getFalseNode() == this.factory.getHigh(bdd));
        if (this.factory.getHigh(bdd) == this.factory.getTrueNode()) {
            BitSet set = new BitSet();
            set.set(variable);
            return set;
        }
        return new BitSet();
    }

    private BooleanExpression<AtomLabel> toExpression(int bdd) {
        if (bdd == this.factory.getFalseNode()) {
            return FALSE;
        }
        if (bdd == this.factory.getTrueNode()) {
            return TRUE;
        }
        BooleanExpression letter = new BooleanExpression((Atom)AtomLabel.createAPIndex((Integer)this.factory.getVariable(bdd)));
        BooleanExpression pos = this.toExpression(this.factory.getHigh(bdd));
        BooleanExpression neg = this.toExpression(this.factory.getLow(bdd));
        if (pos.isTRUE()) {
            pos = letter;
        } else if (!pos.isFALSE()) {
            pos = letter.and(pos);
        }
        if (neg.isTRUE()) {
            neg = letter.not();
        } else if (!neg.isFALSE()) {
            neg = letter.not().and(neg);
        }
        if (pos.isFALSE()) {
            return neg;
        }
        if (neg.isFALSE()) {
            return pos;
        }
        return pos.or(neg);
    }

    private BddValuationSet create(int bdd) {
        return this.canonicalize(new BddValuationSet(this, bdd));
    }

    private int createBdd(BitSet set, BitSet base) {
        assert (base.length() <= this.alphabet.size());
        int bdd = this.factory.getTrueNode();
        int i = base.nextSetBit(0);
        while (i != -1) {
            bdd = this.createBddUpdateHelper(set, i, bdd);
            i = base.nextSetBit(i + 1);
        }
        return bdd;
    }

    private int createBdd(BitSet set) {
        int bdd = this.factory.getTrueNode();
        for (int i = 0; i < this.alphabet.size(); ++i) {
            bdd = this.createBddUpdateHelper(set, i, bdd);
        }
        return bdd;
    }

    private int createBddUpdateHelper(BitSet set, int var, int bdd) {
        int variableNode = this.factory.getVariableNode(var);
        assert (this.factory.isVariable(variableNode));
        return this.factory.and(bdd, set.get(var) ? variableNode : this.factory.not(variableNode));
    }

    private int getBdd(ValuationSet vs) {
        assert (this.equals(vs.getFactory()));
        int bdd = ((BddValuationSet)vs).bdd;
        assert (this.factory.getReferenceCount(bdd) > 0 || this.factory.getReferenceCount(bdd) == -1);
        return bdd;
    }

    static final class BddValuationSet
    extends ValuationSet
    implements GcManagedFactory.BddWrapper {
        final int bdd;

        BddValuationSet(ValuationFactory factory, int bdd) {
            super(factory);
            this.bdd = bdd;
        }

        @Override
        public int bdd() {
            return this.bdd;
        }

        public int hashCode() {
            return HashCommon.mix((int)this.bdd);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !this.getClass().equals(o.getClass())) {
                return false;
            }
            BddValuationSet other = (BddValuationSet)o;
            assert (this.getFactory().equals(other.getFactory()));
            return this.bdd == other.bdd;
        }
    }
}

