/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import owl.ltl.Formula;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.IntVisitor;
import owl.ltl.visitors.Visitor;
import owl.util.annotation.CEntryPoint;

public final class BooleanConstant
extends Formula.LogicalOperator {
    public static final BooleanConstant FALSE = new BooleanConstant(false);
    public static final BooleanConstant TRUE = new BooleanConstant(true);
    public final boolean value;

    private BooleanConstant(boolean value) {
        super(Boolean.hashCode(value));
        this.value = value;
    }

    @CEntryPoint
    public static BooleanConstant of(boolean value) {
        return value ? TRUE : FALSE;
    }

    @Override
    public int accept(IntVisitor v) {
        return v.visit(this);
    }

    @Override
    public <R> R accept(Visitor<R> v) {
        return v.visit(this);
    }

    public <A, B> A accept(BinaryVisitor<B, A> v, B parameter) {
        return v.visit(this, parameter);
    }

    @Override
    public Set<Formula> children() {
        return Set.of();
    }

    @Override
    public boolean isPureEventual() {
        return true;
    }

    @Override
    public boolean isPureUniversal() {
        return true;
    }

    @Override
    public Formula nnf() {
        return this;
    }

    @Override
    @Nonnull
    public BooleanConstant not() {
        return this.value ? FALSE : TRUE;
    }

    @Override
    public Formula substitute(Function<? super Formula.TemporalOperator, ? extends Formula> substitution) {
        return this;
    }

    public String toString() {
        return this.value ? "true" : "false";
    }

    @Override
    protected int compareToImpl(Formula o) {
        BooleanConstant that = (BooleanConstant)o;
        return Boolean.compare(this.value, that.value);
    }

    @Override
    protected boolean equalsImpl(Formula o) {
        assert (o instanceof BooleanConstant);
        assert (this.value != ((BooleanConstant)o).value);
        return false;
    }
}

