/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.visitors;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import owl.ltl.Biconditional;
import owl.ltl.BinaryModalOperator;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.FrequencyG;
import owl.ltl.GOperator;
import owl.ltl.LabelledFormula;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.ROperator;
import owl.ltl.UOperator;
import owl.ltl.UnaryModalOperator;
import owl.ltl.WOperator;
import owl.ltl.XOperator;
import owl.ltl.visitors.Visitor;

public final class PrintVisitor
implements Visitor<String> {
    private final boolean parenthesize;
    @Nullable
    private final List<String> variableMapping;

    private PrintVisitor(boolean parenthesize, @Nullable List<String> variableMapping) {
        this.variableMapping = variableMapping;
        this.parenthesize = parenthesize;
    }

    public static String toString(Formula formula, @Nullable List<String> variableMapping) {
        return PrintVisitor.toString(formula, variableMapping, false);
    }

    public static String toString(Formula formula, @Nullable List<String> variableMapping, boolean parenthesize) {
        PrintVisitor visitor = new PrintVisitor(parenthesize, variableMapping);
        return formula.accept(visitor);
    }

    public static String toString(LabelledFormula formula, boolean parenthesize) {
        PrintVisitor visitor = new PrintVisitor(parenthesize, formula.variables());
        return formula.formula().accept(visitor);
    }

    @Override
    public String visit(Biconditional biconditional) {
        return "(" + this.visitParenthesized(biconditional.left) + " <-> " + this.visitParenthesized(biconditional.right) + ")";
    }

    @Override
    public String visit(BooleanConstant booleanConstant) {
        return booleanConstant.toString();
    }

    @Override
    public String visit(Conjunction conjunction) {
        return "(" + conjunction.children.stream().sorted(Comparator.naturalOrder()).map(this::visitParenthesized).collect(Collectors.joining(" & ")) + ")";
    }

    @Override
    public String visit(Disjunction disjunction) {
        return "(" + disjunction.children.stream().sorted(Comparator.naturalOrder()).map(this::visitParenthesized).collect(Collectors.joining(" | ")) + ")";
    }

    @Override
    public String visit(FOperator fOperator) {
        return this.visit((UnaryModalOperator)fOperator);
    }

    @Override
    public String visit(FrequencyG freq) {
        return "G {" + freq.limes + freq.cmp + freq.bound + "} " + freq.operand.accept(this);
    }

    @Override
    public String visit(GOperator gOperator) {
        return this.visit((UnaryModalOperator)gOperator);
    }

    @Override
    public String visit(Literal literal) {
        String name = this.variableMapping == null ? "p" + literal.getAtom() : this.variableMapping.get(literal.getAtom());
        return literal.isNegated() ? "!" + name : name;
    }

    @Override
    public String visit(MOperator mOperator) {
        return this.visit((BinaryModalOperator)mOperator);
    }

    @Override
    public String visit(ROperator rOperator) {
        return this.visit((BinaryModalOperator)rOperator);
    }

    @Override
    public String visit(UOperator uOperator) {
        return this.visit((BinaryModalOperator)uOperator);
    }

    @Override
    public String visit(WOperator wOperator) {
        return this.visit((BinaryModalOperator)wOperator);
    }

    @Override
    public String visit(XOperator xOperator) {
        return this.visit((UnaryModalOperator)xOperator);
    }

    private String visit(UnaryModalOperator operator) {
        return operator.operatorSymbol() + this.visitParenthesized(operator.operand);
    }

    private String visit(BinaryModalOperator operator) {
        return "((" + operator.left.accept(this) + ") " + operator.operatorSymbol() + " (" + operator.right.accept(this) + "))";
    }

    private String visitParenthesized(Formula formula) {
        return this.parenthesize ? "(" + formula.accept(this) + ")" : formula.accept(this);
    }
}

