/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.dra2dpa;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Table;
import de.tum.in.naturals.IntPreOrder;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import owl.automaton.Automaton;
import owl.automaton.AutomatonFactory;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonFactory;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.algorithms.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.automaton.output.HoaPrinter;
import owl.collections.Collections3;
import owl.translations.dra2dpa.IARState;

final class SccIARBuilder<R> {
    private static final Logger logger = Logger.getLogger(SccIARBuilder.class.getName());
    private final Table<R, IntPreOrder, IARState<R>> iarStates;
    private final GeneralizedRabinAcceptance.RabinPair[] indexToPair;
    private final Automaton<R, RabinAcceptance> rabinAutomaton;
    private final MutableAutomaton<IARState<R>, ParityAcceptance> resultAutomaton;
    private final BitSet usedPriorities;

    SccIARBuilder(Automaton<R, RabinAcceptance> rabinAutomaton, Set<GeneralizedRabinAcceptance.RabinPair> trackedPairs) {
        assert (SccDecomposition.computeSccs(rabinAutomaton).size() == 1);
        this.rabinAutomaton = rabinAutomaton;
        this.usedPriorities = new BitSet(trackedPairs.size() * 2);
        this.usedPriorities.set(0);
        this.iarStates = HashBasedTable.create((int)rabinAutomaton.size(), (int)(rabinAutomaton.size() * trackedPairs.size()));
        this.indexToPair = (GeneralizedRabinAcceptance.RabinPair[])trackedPairs.toArray(GeneralizedRabinAcceptance.RabinPair[]::new);
        this.resultAutomaton = MutableAutomatonFactory.create(new ParityAcceptance(0, ParityAcceptance.Parity.MIN_ODD), rabinAutomaton.factory());
    }

    Automaton<IARState<R>, ParityAcceptance> build() {
        logger.log(Level.FINE, "Building IAR automaton");
        Set<IARState<R>> initialStates = this.getInitialStates();
        logger.log(Level.FINEST, "Starting state space generation from {0}", initialStates);
        Automaton<IARState, ParityAcceptance> sourceAutomaton = AutomatonFactory.create(this.resultAutomaton.factory(), initialStates, (ParityAcceptance)this.resultAutomaton.acceptance(), state -> Collections3.transformMap(this.rabinAutomaton.edgeMap(state.state()), x -> this.computeSuccessorEdge(state.record(), (Edge<R>)x)));
        MutableAutomatonFactory.copy(sourceAutomaton, this.resultAutomaton);
        assert (this.checkGeneratedStates());
        this.optimizeSuccessorRecord();
        this.optimizeInitialStates();
        int maximalUsedPriority = this.getMaximalUsedPriority();
        this.resultAutomaton.updateAcceptance(x -> x.withAcceptanceSets(maximalUsedPriority + 1));
        logger.log(Level.FINER, "Built automaton with {0} states and {1} priorities for input automaton with {2} states and {3} pairs", new Object[]{this.resultAutomaton.size(), maximalUsedPriority, this.rabinAutomaton.size(), this.numberOfTrackedPairs()});
        return this.resultAutomaton;
    }

    private boolean checkGeneratedStates() {
        Set<R> stateSet = this.rabinAutomaton.states();
        Set exploredRabinStates = this.resultAutomaton.states().stream().map(IARState::state).collect(Collectors.toSet());
        assert (stateSet.equals(exploredRabinStates)) : String.format("Explored: %s%nExpected: %s", stateSet, exploredRabinStates);
        return true;
    }

    private Edge<IARState<R>> computeSuccessorEdge(IntPreOrder currentRecord, Edge<R> rabinEdge) {
        int maximumPriority;
        Object rabinSuccessor = rabinEdge.successor();
        IntOpenHashSet visitedFinSetIndices = new IntOpenHashSet();
        int classes = currentRecord.classes();
        int priority = maximumPriority = classes * 2;
        for (int currentClass = 0; currentClass < classes; ++currentClass) {
            for (int rabinPairInClass : currentRecord.equivalenceClass(currentClass)) {
                GeneralizedRabinAcceptance.RabinPair rabinPair = this.indexToPair[rabinPairInClass];
                if (rabinEdge.inSet(rabinPair.finSet())) {
                    visitedFinSetIndices.add(rabinPairInClass);
                    priority = Math.min(priority, maximumPriority - 2 * currentClass - 2);
                    continue;
                }
                if (!rabinEdge.inSet(rabinPair.infSet())) continue;
                priority = Math.min(priority, maximumPriority - 2 * currentClass - 1);
            }
        }
        this.usedPriorities.set(priority);
        IntPreOrder successorRecord = currentRecord.generation((IntSet)visitedFinSetIndices);
        IARState iarSuccessor = this.iarStates.row(rabinSuccessor).computeIfAbsent(successorRecord, record -> IARState.active(rabinSuccessor, record));
        return Edge.of(iarSuccessor, priority);
    }

    private Set<IARState<R>> getInitialStates() {
        IntPreOrder initialRecord = IntPreOrder.coarsest((int)this.numberOfTrackedPairs());
        return this.rabinAutomaton.initialStates().stream().map(initialRabinState -> IARState.active(initialRabinState, initialRecord)).collect(Collectors.toUnmodifiableSet());
    }

    private int getMaximalUsedPriority() {
        return this.usedPriorities.length() - 1;
    }

    private int numberOfTrackedPairs() {
        return this.indexToPair.length;
    }

    private void optimizeInitialStates() {
        List sccs = Lists.reverse(SccDecomposition.computeSccs(this.resultAutomaton));
        int rabinStateCount = this.rabinAutomaton.size();
        HashSet initialStatesToSearch = new HashSet(this.rabinAutomaton.initialStates());
        HashMap initialStateCandidate = new HashMap();
        HashSet rabinStatesInScc = new HashSet();
        HashMap potentialInitialStates = new HashMap();
        for (Set scc : sccs) {
            if (SccDecomposition.isTransient(this.resultAutomaton::successors, scc)) continue;
            rabinStatesInScc.clear();
            potentialInitialStates.clear();
            scc.forEach(sccState -> {
                Object originalState = sccState.state();
                rabinStatesInScc.add(originalState);
                if (initialStatesToSearch.contains(originalState)) {
                    potentialInitialStates.put(originalState, sccState);
                }
            });
            if (potentialInitialStates.isEmpty()) continue;
            assert (rabinStatesInScc.size() <= rabinStateCount);
            if (rabinStatesInScc.size() < rabinStateCount) continue;
            initialStateCandidate.putAll(potentialInitialStates);
            initialStatesToSearch.removeAll(potentialInitialStates.keySet());
            if (!initialStatesToSearch.isEmpty()) continue;
            break;
        }
        assert (initialStateCandidate.size() == this.rabinAutomaton.initialStates().size());
        this.resultAutomaton.initialStates(initialStateCandidate.values());
        this.resultAutomaton.trim();
    }

    private void optimizeSuccessorRecord() {
        HashBasedTable refinementTable = HashBasedTable.create();
        HashSet unknownStates = new HashSet();
        HashSet topElements = new HashSet();
        this.rabinAutomaton.states().forEach(arg_0 -> this.lambda$optimizeSuccessorRecord$11(topElements, unknownStates, (Table)refinementTable, arg_0));
        if (refinementTable.isEmpty()) {
            logger.log(Level.FINE, "No refinements found");
            return;
        }
        if (logger.isLoggable(Level.FINEST)) {
            StringBuilder stringBuilder = new StringBuilder("Refinements:");
            this.rabinAutomaton.states().forEach(arg_0 -> SccIARBuilder.lambda$optimizeSuccessorRecord$14((Table)refinementTable, stringBuilder, arg_0));
            logger.log(Level.FINEST, stringBuilder.toString());
            logger.log(Level.FINEST, "Automaton before refinement:\n{0}", HoaPrinter.toString(this.resultAutomaton));
        }
        this.resultAutomaton.initialStates(this.resultAutomaton.initialStates().stream().map(arg_0 -> SccIARBuilder.lambda$optimizeSuccessorRecord$15((Table)refinementTable, arg_0)).collect(Collectors.toUnmodifiableSet()));
        this.resultAutomaton.updateEdges((arg_0, arg_1) -> SccIARBuilder.lambda$optimizeSuccessorRecord$16((Table)refinementTable, arg_0, arg_1));
        this.resultAutomaton.removeStateIf(arg_0 -> SccIARBuilder.lambda$optimizeSuccessorRecord$17((Table)refinementTable, arg_0));
        this.resultAutomaton.trim();
        logger.log(Level.FINEST, () -> String.format("Automaton after refinement:%n%s", HoaPrinter.toString(this.resultAutomaton)));
    }

    private static /* synthetic */ boolean lambda$optimizeSuccessorRecord$17(Table refinementTable, IARState state) {
        return refinementTable.contains(state.state(), (Object)state.record());
    }

    private static /* synthetic */ Edge lambda$optimizeSuccessorRecord$16(Table refinementTable, IARState state, Edge edge) {
        IARState successor = (IARState)edge.successor();
        Object rabinSuccessor = successor.state();
        IARState refinedSuccessor = (IARState)refinementTable.get(rabinSuccessor, (Object)successor.record());
        return refinedSuccessor == null ? edge : edge.withSuccessor(refinedSuccessor);
    }

    private static /* synthetic */ IARState lambda$optimizeSuccessorRecord$15(Table refinementTable, IARState initialState) {
        IARState refinedInitialState = (IARState)refinementTable.get(initialState.state(), (Object)initialState.record());
        return Objects.requireNonNullElse(refinedInitialState, initialState);
    }

    private static /* synthetic */ void lambda$optimizeSuccessorRecord$14(Table refinementTable, StringBuilder stringBuilder, Object rabinState) {
        Map refinements = refinementTable.row(rabinState);
        if (refinements.isEmpty()) {
            return;
        }
        stringBuilder.append('\n').append(rabinState).append(':');
        Map inverse = ((ArrayListMultimap)Multimaps.invertFrom((Multimap)Multimaps.forMap((Map)refinements), (Multimap)ArrayListMultimap.create())).asMap();
        inverse.forEach((iarState, stateRefinements) -> {
            stringBuilder.append("\n  ").append(iarState.record()).append(" <-");
            stateRefinements.forEach(refinement -> stringBuilder.append(' ').append(refinement));
        });
    }

    private /* synthetic */ void lambda$optimizeSuccessorRecord$11(Set topElements, Set unknownStates, Table refinementTable, Object rabinState) {
        assert (topElements.isEmpty() && unknownStates.isEmpty());
        unknownStates.addAll(this.iarStates.row(rabinState).values());
        Map foundRefinements = refinementTable.row(rabinState);
        Iterator iterator = unknownStates.iterator();
        while (iterator.hasNext()) {
            IARState currentState = (IARState)iterator.next();
            IntPreOrder currentRecord = currentState.record();
            iterator.remove();
            Optional<IARState> refiningTopStateOptional = topElements.parallelStream().filter(state -> state.record().refines(currentRecord)).findAny();
            if (refiningTopStateOptional.isPresent()) {
                foundRefinements.put(currentRecord, refiningTopStateOptional.get());
                continue;
            }
            Optional<IARState> refiningUnknownStateOptional = unknownStates.parallelStream().filter(state -> state.record().refines(currentRecord)).findAny();
            if (refiningUnknownStateOptional.isPresent()) {
                IARState refiningUnknownState = refiningUnknownStateOptional.get();
                foundRefinements.put(currentRecord, refiningUnknownState);
                continue;
            }
            topElements.add(currentState);
        }
        assert (unknownStates.isEmpty());
        HashMap refinementReplacement = new HashMap();
        foundRefinements.forEach((order, refiningState) -> {
            if (topElements.contains(refiningState)) {
                return;
            }
            IARState refiningTopElement = topElements.parallelStream().filter(topElement -> topElement.record().refines(refiningState.record())).findAny().orElseThrow();
            refinementReplacement.put(order, refiningTopElement);
        });
        foundRefinements.putAll(refinementReplacement);
        topElements.clear();
    }
}

