/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.nbadet;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.edge.Edge;
import owl.collections.Pair;
import owl.translations.nbadet.AutoValue_NbaDetState;
import owl.translations.nbadet.NbaDetConf;
import owl.translations.nbadet.NbaDetStateFactory;
import owl.translations.nbadet.RankedSlice;
import owl.translations.nbadet.SmartSucc;
import owl.util.BitSetUtil;

@AutoValue
public abstract class NbaDetState<S> {
    @Nullable
    ImmutableBiMap<Integer, S> states;

    public abstract BitSet powerSet();

    public abstract BitSet rSccs();

    public abstract BitSet aSccsBuffer();

    public abstract Optional<Pair<BitSet, Integer>> aSccs();

    public abstract ArrayList<RankedSlice> dSccs();

    public abstract ArrayList<RankedSlice> mSccs();

    public static <S> NbaDetState<S> of(NbaDetConf<S> conf, Set<S> initialSet) {
        return NbaDetState.of(conf, BitSetUtil.fromSet(initialSet, conf.aut().stateMap()));
    }

    public static <S> NbaDetState<S> of(NbaDetConf<S> conf, BitSet nbaSet) {
        NbaDetStateFactory.RankGen rank = NbaDetStateFactory.RankGen.from(0);
        BitSet rSccs = BitSetUtil.intersection(nbaSet, conf.sets().rsccStates());
        BitSet aSccsBuf = BitSetUtil.intersection(nbaSet, conf.sets().asccStates());
        ArrayList<RankedSlice> dSccs = new ArrayList<RankedSlice>();
        for (BitSet bitSet : conf.sets().dsccsStates()) {
            BitSet tmp = BitSetUtil.intersection(nbaSet, bitSet);
            if (tmp.isEmpty()) {
                dSccs.add(RankedSlice.empty());
                continue;
            }
            dSccs.add(RankedSlice.singleton(Pair.of(tmp, rank.fresh())));
        }
        ArrayList<RankedSlice> mSccs = new ArrayList<RankedSlice>();
        for (BitSet s : conf.sets().msccsStates()) {
            BitSet tmp = BitSetUtil.intersection(nbaSet, s);
            if (tmp.isEmpty()) {
                mSccs.add(RankedSlice.empty());
                continue;
            }
            mSccs.add(RankedSlice.singleton(Pair.of(tmp, rank.fresh())));
        }
        AutoValue_NbaDetState autoValue_NbaDetState = new AutoValue_NbaDetState(nbaSet, rSccs, aSccsBuf, Optional.empty(), dSccs, mSccs);
        autoValue_NbaDetState.states = conf.aut().stateMap().inverse();
        return autoValue_NbaDetState;
    }

    public Edge<NbaDetState<S>> successor(NbaDetConf<S> conf, BitSet val) {
        return NbaDetStateFactory.successor(this, conf, val);
    }

    public List<BitSet> toTrieEncoding() {
        ArrayList<Pair> unpruned = new ArrayList<Pair>();
        unpruned.add(Pair.of(this.powerSet(), -1));
        if (this.aSccs().isPresent()) {
            unpruned.add(this.aSccs().get());
        }
        for (RankedSlice mscc : this.mSccs()) {
            unpruned.addAll(SmartSucc.unprune(mscc.slice()));
        }
        for (RankedSlice dscc : this.dSccs()) {
            unpruned.addAll(SmartSucc.unprune(dscc.slice()));
        }
        unpruned.sort(Comparator.comparing(Pair::snd));
        return unpruned.stream().map(Pair::fst).collect(Collectors.toCollection(ArrayList::new));
    }

    public boolean finerOrEqual(NbaDetState<S> o) {
        int i;
        if (!(this.powerSet().equals(o.powerSet()) && this.aSccs().equals(o.aSccs()) && this.rSccs().equals(o.rSccs()))) {
            return false;
        }
        if (this.mSccs().size() != o.mSccs().size() || this.dSccs().size() != o.dSccs().size()) {
            return false;
        }
        for (i = 0; i < this.mSccs().size(); ++i) {
            if (SmartSucc.finerOrEqual(this.mSccs().get(i), o.mSccs().get(i))) continue;
            return false;
        }
        for (i = 0; i < this.dSccs().size(); ++i) {
            if (SmartSucc.finerOrEqual(this.dSccs().get(i), o.dSccs().get(i))) continue;
            return false;
        }
        return true;
    }

    public final String toString() {
        return "N:" + BitSetUtil.toSet(this.rSccs(), arg_0 -> this.states.get(arg_0)) + "\tAB:" + BitSetUtil.toSet(this.aSccsBuffer(), arg_0 -> this.states.get(arg_0)) + " AC: (" + (String)(this.aSccs().isPresent() ? BitSetUtil.toSet(this.aSccs().get().fst(), arg_0 -> this.states.get(arg_0)) + "=" + this.aSccs().get().snd() : "") + ") D:(" + this.dSccs().stream().map(sl -> sl.toString(arg_0 -> this.states.get(arg_0))).collect(Collectors.joining(" | ")) + ") M:(" + this.mSccs().stream().map(sl -> sl.toString(arg_0 -> this.states.get(arg_0))).collect(Collectors.joining(" | ")) + ")";
    }

    public static int rankToPriority(int rank, boolean isGood) {
        return 2 * (rank + 1) - (isGood ? 0 : 1);
    }

    public static Pair<Integer, Boolean> priorityToRank(int prio) {
        return Pair.of((prio + 1) / 2 - 1, prio % 2 == 0);
    }

    public static <S> int rankUpperBound(NbaDetConf<S> c) {
        return c.aut().original().states().size();
    }

    public static <S> int weakestBadPrio(NbaDetConf<S> c) {
        return NbaDetState.rankToPriority(NbaDetState.rankUpperBound(c) + 1, false);
    }

    public static <S> ParityAcceptance getAcceptance(NbaDetConf<S> c) {
        return new ParityAcceptance(NbaDetState.weakestBadPrio(c) + 1, ParityAcceptance.Parity.MIN_EVEN);
    }
}

