/*
 * Decompiled with CFR 0.152.
 */
package owl.translations;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import owl.automaton.Automaton;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.ltl.LabelledFormula;
import owl.run.Environment;
import owl.translations.canonical.NonDeterministicConstructionsPortfolio;
import owl.translations.ltl2nba.SymmetricNBAConstruction;

public final class LTL2NAFunction
implements Function<LabelledFormula, Automaton<?, ?>> {
    private static final Set<Class<? extends OmegaAcceptance>> SUPPORTED_ACCEPTANCE_CONDITIONS = Set.of(BuchiAcceptance.class, GeneralizedBuchiAcceptance.class, OmegaAcceptance.class);
    private final Function<LabelledFormula, ? extends Automaton<?, ?>> fallback;
    private final NonDeterministicConstructionsPortfolio<?> portfolio;

    public LTL2NAFunction(Environment environment) {
        this(OmegaAcceptance.class, environment);
    }

    public LTL2NAFunction(Class<? extends OmegaAcceptance> acceptance, Environment environment) {
        Preconditions.checkArgument((boolean)SUPPORTED_ACCEPTANCE_CONDITIONS.contains(acceptance), (String)"%s is not in the set %s of supported acceptance conditions.", acceptance, SUPPORTED_ACCEPTANCE_CONDITIONS);
        Class castedAcceptance = OmegaAcceptance.class.equals(acceptance) || GeneralizedBuchiAcceptance.class.equals(acceptance) ? GeneralizedBuchiAcceptance.class : BuchiAcceptance.class;
        this.fallback = SymmetricNBAConstruction.of(environment, castedAcceptance);
        this.portfolio = new NonDeterministicConstructionsPortfolio<OmegaAcceptance>(acceptance, environment);
    }

    @Override
    public Automaton<?, ?> apply(LabelledFormula formula) {
        Optional<Automaton<?, ?>> portfolioResult = this.portfolio.apply(formula);
        if (portfolioResult.isPresent()) {
            return portfolioResult.orElseThrow();
        }
        return this.fallback.apply(formula);
    }
}

