/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2dpa;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import owl.automaton.AnnotatedStateOptimisation;
import owl.automaton.Automaton;
import owl.automaton.BooleanOperations;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonUtil;
import owl.automaton.ParityUtil;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.acceptance.optimization.ParityAcceptanceOptimizations;
import owl.factories.EquivalenceClassFactory;
import owl.ltl.BooleanConstant;
import owl.ltl.LabelledFormula;
import owl.run.Environment;
import owl.translations.ltl2dpa.AsymmetricDPAConstruction;
import owl.translations.ltl2dpa.AsymmetricRankingState;
import owl.translations.ltl2dpa.SymmetricDPAConstruction;
import owl.translations.ltl2dpa.SymmetricRankingState;
import owl.translations.mastertheorem.Selector;

public class LTL2DPAFunction
implements Function<LabelledFormula, Automaton<?, ParityAcceptance>> {
    public static final EnumSet<Configuration> RECOMMENDED_ASYMMETRIC_CONFIG = EnumSet.of(Configuration.OPTIMISE_INITIAL_STATE, Configuration.COMPLEMENT_CONSTRUCTION_EXACT, Configuration.COMPRESS_COLOURS);
    public static final EnumSet<Configuration> RECOMMENDED_SYMMETRIC_CONFIG = EnumSet.of(Configuration.SYMMETRIC, Configuration.OPTIMISE_INITIAL_STATE, Configuration.COMPLEMENT_CONSTRUCTION_EXACT, Configuration.COMPRESS_COLOURS);
    private final EnumSet<Configuration> configuration;
    private final Environment environment;
    private final AsymmetricDPAConstruction asymmetricDPAConstruction;
    private final SymmetricDPAConstruction symmetricDPAConstruction;

    public LTL2DPAFunction(Environment environment, EnumSet<Configuration> configuration) {
        Preconditions.checkArgument((!configuration.contains((Object)Configuration.COMPLEMENT_CONSTRUCTION_EXACT) || !configuration.contains((Object)Configuration.COMPLEMENT_CONSTRUCTION_HEURISTIC) ? 1 : 0) != 0, (Object)"COMPLEMENT_CONSTRUCTION_EXACT and HEURISTIC cannot be used together.");
        this.configuration = EnumSet.copyOf(configuration);
        this.environment = environment;
        this.asymmetricDPAConstruction = new AsymmetricDPAConstruction(environment);
        this.symmetricDPAConstruction = new SymmetricDPAConstruction(environment);
    }

    @Override
    public Automaton<?, ParityAcceptance> apply(LabelledFormula formula) {
        Supplier<Optional> complementSupplier;
        Supplier<Optional> automatonSupplier;
        if (this.configuration.contains((Object)Configuration.COMPLEMENT_CONSTRUCTION_HEURISTIC)) {
            int negationFixpoints;
            int fixpoints = this.configuration.contains((Object)Configuration.SYMMETRIC) ? LTL2DPAFunction.getOrMaxInt(() -> Selector.selectSymmetric(formula.formula(), false).size()) : LTL2DPAFunction.getOrMaxInt(() -> Selector.selectAsymmetric(formula.formula(), false).size());
            int n = negationFixpoints = this.configuration.contains((Object)Configuration.SYMMETRIC) ? LTL2DPAFunction.getOrMaxInt(() -> Selector.selectSymmetric(formula.formula().not(), false).size()) : LTL2DPAFunction.getOrMaxInt(() -> Selector.selectAsymmetric(formula.formula().not(), false).size());
            if (fixpoints == Integer.MAX_VALUE && negationFixpoints == Integer.MAX_VALUE) {
                throw new IllegalStateException("Too many fixpoints.");
            }
            if (fixpoints <= negationFixpoints) {
                automatonSupplier = this.configuration.contains((Object)Configuration.SYMMETRIC) ? () -> Optional.of(this.symmetricConstruction(formula)) : () -> Optional.of(this.asymmetricConstruction(formula));
                complementSupplier = Optional::empty;
            } else {
                automatonSupplier = Optional::empty;
                complementSupplier = this.configuration.contains((Object)Configuration.SYMMETRIC) ? () -> Optional.of(this.symmetricConstruction(formula.not())) : () -> Optional.of(this.asymmetricConstruction(formula.not()));
            }
        } else {
            Supplier<Optional> supplier = automatonSupplier = this.configuration.contains((Object)Configuration.SYMMETRIC) ? () -> Optional.of(this.symmetricConstruction(formula)) : () -> Optional.of(this.asymmetricConstruction(formula));
            complementSupplier = this.configuration.contains((Object)Configuration.COMPLEMENT_CONSTRUCTION_EXACT) ? (this.configuration.contains((Object)Configuration.SYMMETRIC) ? () -> Optional.of(this.symmetricConstruction(formula.not())) : () -> Optional.of(this.asymmetricConstruction(formula.not()))) : Optional::empty;
        }
        AtomicReference complementReference = new AtomicReference();
        Thread complementThread = new Thread(() -> ((Optional)complementSupplier.get()).map(Result::complement).ifPresent(complementReference::set));
        complementThread.setDaemon(true);
        complementThread.start();
        Automaton automaton = automatonSupplier.get().map(x -> x.automaton).orElse(null);
        Uninterruptibles.joinUninterruptibly((Thread)complementThread);
        Automaton complement = (Automaton)complementReference.get();
        if (complement == null) {
            return Objects.requireNonNull(automaton);
        }
        if (automaton == null) {
            return Objects.requireNonNull(complement);
        }
        if (automaton.size() < complement.size()) {
            return automaton;
        }
        if (automaton.size() > complement.size()) {
            return complement;
        }
        return ((ParityAcceptance)automaton.acceptance()).acceptanceSets() <= ((ParityAcceptance)complement.acceptance()).acceptanceSets() ? automaton : complement;
    }

    private Result<AsymmetricRankingState> asymmetricConstruction(LabelledFormula formula) {
        Automaton<AsymmetricRankingState, ParityAcceptance> optimisedDpa;
        Automaton<AsymmetricRankingState, ParityAcceptance> dpa = this.asymmetricDPAConstruction.of(formula);
        Automaton<AsymmetricRankingState, ParityAcceptance> automaton = optimisedDpa = this.configuration.contains((Object)Configuration.OPTIMISE_INITIAL_STATE) ? MutableAutomatonUtil.asMutable(AnnotatedStateOptimisation.optimizeInitialState(dpa)) : dpa;
        if (optimisedDpa.initialStates().isEmpty()) {
            EquivalenceClassFactory factory = this.environment.factorySupplier().getEquivalenceClassFactory(formula.atomicPropositions());
            return new Result<AsymmetricRankingState>(optimisedDpa, AsymmetricRankingState.of(factory.of(BooleanConstant.FALSE)), this.configuration.contains((Object)Configuration.COMPRESS_COLOURS));
        }
        return new Result<AsymmetricRankingState>(optimisedDpa, AsymmetricRankingState.of(dpa.onlyInitialState().state().factory().of(BooleanConstant.FALSE)), this.configuration.contains((Object)Configuration.COMPRESS_COLOURS));
    }

    private Result<SymmetricRankingState> symmetricConstruction(LabelledFormula formula) {
        Automaton<SymmetricRankingState, ParityAcceptance> dpa = this.symmetricDPAConstruction.of(formula);
        Automaton<SymmetricRankingState, ParityAcceptance> optimisedDpa = this.configuration.contains((Object)Configuration.OPTIMISE_INITIAL_STATE) ? MutableAutomatonUtil.asMutable(AnnotatedStateOptimisation.optimizeInitialState(dpa)) : dpa;
        return new Result<SymmetricRankingState>(optimisedDpa, SymmetricRankingState.of(Map.of()), this.configuration.contains((Object)Configuration.COMPRESS_COLOURS));
    }

    private static int getOrMaxInt(IntSupplier supplier) {
        try {
            return supplier.getAsInt();
        }
        catch (IllegalArgumentException ex) {
            return Integer.MAX_VALUE;
        }
    }

    private static final class Result<T> {
        final Automaton<T, ParityAcceptance> automaton;
        final T sinkState;

        Result(Automaton<T, ParityAcceptance> automaton, T sinkState, boolean compressColours) {
            this.sinkState = sinkState;
            this.automaton = compressColours ? ParityAcceptanceOptimizations.minimizePriorities(MutableAutomatonUtil.asMutable(automaton)) : automaton;
        }

        Automaton<T, ParityAcceptance> complement() {
            if (this.automaton instanceof MutableAutomaton || this.automaton.acceptance().parity() != ParityAcceptance.Parity.MIN_ODD) {
                return ParityUtil.complement(MutableAutomatonUtil.asMutable(this.automaton), this.sinkState);
            }
            assert (this.automaton.acceptance().parity() == ParityAcceptance.Parity.MIN_ODD);
            return BooleanOperations.deterministicComplement(this.automaton, this.sinkState, ParityAcceptance.class);
        }
    }

    public static enum Configuration {
        SYMMETRIC,
        COMPLEMENT_CONSTRUCTION_EXACT,
        COMPLEMENT_CONSTRUCTION_HEURISTIC,
        OPTIMISE_INITIAL_STATE,
        COMPRESS_COLOURS;

    }
}

