/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.mastertheorem;

import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.LabelledFormula;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.ROperator;
import owl.ltl.SyntacticFragment;
import owl.ltl.SyntacticFragments;
import owl.ltl.UOperator;
import owl.ltl.WOperator;
import owl.ltl.rewriter.NormalForms;
import owl.ltl.visitors.Converter;
import owl.ltl.visitors.PropositionalVisitor;
import owl.translations.mastertheorem.Fixpoints;
import owl.translations.mastertheorem.Rewriter;
import owl.translations.mastertheorem.Selector;

public class Normalisation
implements UnaryOperator<LabelledFormula> {
    private final boolean dual;
    private final boolean local;
    private final boolean onlyStableWords;

    private Normalisation(boolean dual, boolean local, boolean onlyStableWords) {
        this.dual = dual;
        this.local = local;
        this.onlyStableWords = onlyStableWords;
    }

    public static Normalisation of(boolean dual, boolean local, boolean onlyStableWords) {
        return new Normalisation(dual, local, onlyStableWords);
    }

    @Override
    public LabelledFormula apply(LabelledFormula labelledFormula) {
        Formula formula = labelledFormula.formula().nnf();
        List<String> atomicPropositions = List.copyOf(labelledFormula.atomicPropositions());
        ArrayList<Formula> disjuncts = new ArrayList<Formula>();
        if (this.local && !(formula instanceof Formula.TemporalOperator)) {
            LocalNormalisation localNormalForm = new LocalNormalisation(atomicPropositions);
            return LabelledFormula.of(formula.accept(localNormalForm), atomicPropositions);
        }
        for (Fixpoints fixpoints : Selector.selectSymmetric(formula, true)) {
            ArrayList<Formula> conjuncts = new ArrayList<Formula>();
            Rewriter.ToCoSafety toCoSafety = new Rewriter.ToCoSafety(fixpoints);
            Rewriter.ToSafety toSafety = new Rewriter.ToSafety(fixpoints);
            if (this.onlyStableWords) {
                if (this.dual) {
                    conjuncts.add(toCoSafety.apply(formula));
                } else {
                    conjuncts.add(toSafety.apply(formula));
                }
            } else if (this.dual) {
                conjuncts.add(formula.accept(new ToPi2(fixpoints)));
            } else {
                conjuncts.add(formula.accept(new ToSigma2(fixpoints)));
            }
            for (Formula.TemporalOperator leastFixpoint : fixpoints.leastFixpoints()) {
                conjuncts.add(GOperator.of(FOperator.of(toCoSafety.apply(leastFixpoint))));
            }
            for (Formula.TemporalOperator greatestFixpoint : fixpoints.greatestFixpoints()) {
                conjuncts.add(FOperator.of(GOperator.of(toSafety.apply(greatestFixpoint))));
            }
            disjuncts.add(Conjunction.of(conjuncts));
        }
        Formula disjunction = NormalForms.toDnfFormula(Disjunction.of(disjuncts));
        assert (SyntacticFragments.DELTA_2.contains(disjunction));
        return labelledFormula.wrap(disjunction);
    }

    private static class ToPi2
    extends Converter {
        private final Rewriter.ToCoSafety toCoSafety;

        private ToPi2(Fixpoints fixpoints) {
            super(SyntacticFragment.NNF);
            this.toCoSafety = new Rewriter.ToCoSafety(fixpoints);
        }

        @Override
        public Formula visit(FOperator fOperator) {
            return WOperator.of(FOperator.of(this.toCoSafety.apply(fOperator.operand())), fOperator.operand().accept(this));
        }

        @Override
        public Formula visit(MOperator mOperator) {
            return ROperator.of(mOperator.leftOperand().accept(this), Conjunction.of(mOperator.rightOperand().accept(this), FOperator.of(this.toCoSafety.apply(mOperator.leftOperand()))));
        }

        @Override
        public Formula visit(UOperator uOperator) {
            return WOperator.of(Conjunction.of(uOperator.leftOperand().accept(this), FOperator.of(this.toCoSafety.apply(uOperator.rightOperand()))), uOperator.rightOperand().accept(this));
        }
    }

    private static class ToSigma2
    extends Converter {
        private final Rewriter.ToSafety toSafety;

        private ToSigma2(Fixpoints fixpoints) {
            super(SyntacticFragment.NNF);
            this.toSafety = new Rewriter.ToSafety(fixpoints);
        }

        @Override
        public Formula visit(GOperator gOperator) {
            return UOperator.of(gOperator.operand().accept(this), GOperator.of(this.toSafety.apply(gOperator.operand())));
        }

        @Override
        public Formula visit(ROperator rOperator) {
            return MOperator.of(Disjunction.of(rOperator.leftOperand().accept(this), GOperator.of(this.toSafety.apply(rOperator.rightOperand()))), rOperator.rightOperand().accept(this));
        }

        @Override
        public Formula visit(WOperator wOperator) {
            return UOperator.of(wOperator.leftOperand().accept(this), Disjunction.of(wOperator.rightOperand().accept(this), GOperator.of(this.toSafety.apply(wOperator.leftOperand()))));
        }
    }

    private class LocalNormalisation
    extends PropositionalVisitor<Formula> {
        private final List<String> atomicPropositions;

        private LocalNormalisation(List<String> atomicPropositions) {
            this.atomicPropositions = atomicPropositions;
        }

        @Override
        public Formula visit(BooleanConstant booleanConstant) {
            return booleanConstant;
        }

        @Override
        public Formula visit(Conjunction conjunction) {
            return Conjunction.of(conjunction.map(x -> x.accept(this)));
        }

        @Override
        public Formula visit(Disjunction disjunction) {
            return Disjunction.of(disjunction.map(x -> x.accept(this)));
        }

        @Override
        public Formula visit(Literal literal) {
            return literal;
        }

        @Override
        public Formula visit(Formula.TemporalOperator temporalOperator) {
            if (SyntacticFragments.DELTA_2.contains(temporalOperator)) {
                return temporalOperator;
            }
            return Normalisation.this.apply(LabelledFormula.of(temporalOperator, this.atomicPropositions)).formula();
        }
    }
}

