/*
 * Decompiled with CFR 0.152.
 */
package owl.util;

public final class ArraysSupport {
    public static final int MAX_ARRAY_LENGTH = 0x7FFFFFF7;

    private ArraysSupport() {
    }

    public static int newLength(int oldLength, int minGrowth, int prefGrowth) {
        assert (oldLength >= 0);
        assert (minGrowth > 0);
        int newLength = Math.max(minGrowth, prefGrowth) + oldLength;
        if (newLength - 0x7FFFFFF7 <= 0) {
            return newLength;
        }
        int minLength = oldLength + minGrowth;
        if (minLength < 0) {
            throw new OutOfMemoryError("Required array length too large");
        }
        return 0x7FFFFFF7;
    }
}

