/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.set;

import com.zaxxer.sparsebits.SparseBitSet;
import de.tum.in.naturals.set.BoundedMutableSingletonNatBitSet;
import de.tum.in.naturals.set.BoundedNatBitSet;
import de.tum.in.naturals.set.FixedSizeNatBitSet;
import de.tum.in.naturals.set.LongBoundedNatBitSet;
import de.tum.in.naturals.set.LongNatBitSet;
import de.tum.in.naturals.set.MutableSingletonNatBitSet;
import de.tum.in.naturals.set.NatBitSet;
import de.tum.in.naturals.set.NatBitSetFactory;
import de.tum.in.naturals.set.NatBitSets;
import de.tum.in.naturals.set.RoaringBoundedNatBitSet;
import de.tum.in.naturals.set.RoaringNatBitSet;
import de.tum.in.naturals.set.SimpleBoundedNatBitSet;
import de.tum.in.naturals.set.SimpleNatBitSet;
import de.tum.in.naturals.set.SparseBoundedNatBitSet;
import de.tum.in.naturals.set.SparseNatBitSet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import java.util.BitSet;
import javax.annotation.Nonnegative;
import org.roaringbitmap.RoaringBitmap;

public abstract class AbstractNatBitSetFactory
implements NatBitSetFactory {
    @Override
    public BoundedNatBitSet boundedSet(int domainSize, int expectedSize) {
        if (domainSize <= LongBoundedNatBitSet.maximalSize()) {
            return new LongBoundedNatBitSet(domainSize);
        }
        return this.makeBoundedSet(domainSize, expectedSize);
    }

    protected abstract BoundedNatBitSet makeBoundedSet(int var1, int var2);

    @Override
    public boolean isModifiable(BoundedNatBitSet set) {
        return set instanceof LongBoundedNatBitSet || set instanceof SimpleBoundedNatBitSet || set instanceof SparseBoundedNatBitSet || set instanceof RoaringBoundedNatBitSet;
    }

    @Override
    public NatBitSet compact(NatBitSet set, boolean forceCopy) {
        if (set instanceof MutableSingletonNatBitSet || set instanceof FixedSizeNatBitSet) {
            return set;
        }
        if (set.isEmpty()) {
            return NatBitSets.emptySet();
        }
        if (set.size() == 1) {
            return NatBitSets.singleton(set.firstInt());
        }
        if (set.firstInt() == 0 && set.lastInt() == set.size() - 1) {
            return new FixedSizeNatBitSet(set.lastInt() + 1);
        }
        if (!(set instanceof LongNatBitSet) && set.lastInt() < LongNatBitSet.maximalSize()) {
            LongNatBitSet copy = new LongNatBitSet();
            set.forEach(copy::set);
            return copy;
        }
        return forceCopy ? set.clone() : set;
    }

    @Override
    public boolean isModifiable(NatBitSet set, int length) {
        if (length == 0) {
            return true;
        }
        if (set instanceof BoundedNatBitSet) {
            BoundedNatBitSet boundedSet = (BoundedNatBitSet)set;
            return length <= boundedSet.domainSize() && this.isModifiable(boundedSet);
        }
        if (set instanceof LongNatBitSet) {
            return length <= LongNatBitSet.maximalSize();
        }
        return set instanceof SimpleNatBitSet || set instanceof SparseNatBitSet || set instanceof RoaringNatBitSet;
    }

    @Override
    public BoundedNatBitSet ensureBounded(NatBitSet set, @Nonnegative int domainSize) {
        if (domainSize <= 0) {
            throw new IllegalArgumentException();
        }
        if (!set.isEmpty() && set.lastInt() >= domainSize) {
            throw new IndexOutOfBoundsException();
        }
        if (set instanceof BoundedNatBitSet) {
            BoundedNatBitSet boundedSet = (BoundedNatBitSet)set;
            int oldDomainSize = boundedSet.domainSize();
            if (oldDomainSize == domainSize) {
                return boundedSet;
            }
            if (set instanceof SimpleBoundedNatBitSet) {
                SimpleBoundedNatBitSet simpleBoundedSet = (SimpleBoundedNatBitSet)set;
                BitSet bitSetCopy = (BitSet)simpleBoundedSet.getBitSet().clone();
                if (simpleBoundedSet.isComplement()) {
                    if (domainSize < oldDomainSize) {
                        bitSetCopy.clear(domainSize, oldDomainSize);
                    } else {
                        bitSetCopy.set(oldDomainSize, domainSize);
                    }
                }
                SimpleBoundedNatBitSet copy = new SimpleBoundedNatBitSet(bitSetCopy, domainSize);
                return simpleBoundedSet.isComplement() ? copy.complement() : copy;
            }
            if (set instanceof SparseBoundedNatBitSet) {
                SparseBoundedNatBitSet sparseBoundedSet = (SparseBoundedNatBitSet)set;
                SparseBitSet bitSetCopy = sparseBoundedSet.getBitSet().clone();
                if (sparseBoundedSet.isComplement()) {
                    if (domainSize < oldDomainSize) {
                        bitSetCopy.clear(domainSize, oldDomainSize);
                    } else {
                        bitSetCopy.set(oldDomainSize, domainSize);
                    }
                }
                SparseBoundedNatBitSet copy = new SparseBoundedNatBitSet(bitSetCopy, domainSize);
                return sparseBoundedSet.isComplement() ? copy.complement() : copy;
            }
            if (set instanceof MutableSingletonNatBitSet) {
                MutableSingletonNatBitSet singletonSet = (MutableSingletonNatBitSet)set;
                return singletonSet.isEmpty() ? new BoundedMutableSingletonNatBitSet(domainSize) : new BoundedMutableSingletonNatBitSet(singletonSet.firstInt(), domainSize);
            }
            if (set instanceof RoaringBoundedNatBitSet) {
                RoaringBoundedNatBitSet sparseBoundedSet = (RoaringBoundedNatBitSet)set;
                RoaringBitmap bitmapCopy = sparseBoundedSet.bitmap().clone();
                if (sparseBoundedSet.isComplement()) {
                    if (domainSize < oldDomainSize) {
                        bitmapCopy.remove((long)domainSize, (long)oldDomainSize);
                    } else {
                        bitmapCopy.add((long)oldDomainSize, (long)domainSize);
                    }
                }
                RoaringBoundedNatBitSet copy = new RoaringBoundedNatBitSet(bitmapCopy, domainSize);
                return sparseBoundedSet.isComplement() ? copy.complement() : copy;
            }
        }
        BoundedNatBitSet copy = this.boundedSet(domainSize, set.size());
        copy.or((IntCollection)set);
        return copy;
    }
}

