/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.set;

import de.tum.in.naturals.bitset.RoaringBitmaps;
import de.tum.in.naturals.set.AbstractBoundedNatBitSet;
import de.tum.in.naturals.set.NatBitSetsUtil;
import de.tum.in.naturals.set.RoaringNatBitSet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.IntPredicate;
import javax.annotation.Nonnegative;
import org.roaringbitmap.RoaringBitmap;

class RoaringBoundedNatBitSet
extends AbstractBoundedNatBitSet {
    private static final long INFINITY = 0x80000000L;
    private final RoaringBitmap bitmap;
    private final boolean complement;
    private final RoaringBoundedNatBitSet complementView;

    private RoaringBoundedNatBitSet(RoaringBoundedNatBitSet other) {
        super(other.domainSize());
        this.bitmap = other.bitmap;
        this.complement = !other.complement;
        this.complementView = other;
        assert (this.checkConsistency());
    }

    private RoaringBoundedNatBitSet(RoaringBitmap bitmap, @Nonnegative int domainSize, boolean complement) {
        super(domainSize);
        this.bitmap = bitmap;
        this.complement = complement;
        this.complementView = new RoaringBoundedNatBitSet(this);
        assert (this.checkConsistency());
    }

    RoaringBoundedNatBitSet(RoaringBitmap bitmap, @Nonnegative int domainSize) {
        this(bitmap, domainSize, false);
    }

    @Override
    boolean isComplement() {
        return this.complement;
    }

    public boolean isEmpty() {
        assert (this.checkConsistency());
        if (this.complement) {
            return this.bitmap.getCardinality() == this.domainSize();
        }
        return this.bitmap.isEmpty();
    }

    public int size() {
        assert (this.checkConsistency());
        int bitSetCardinality = this.bitmap.getCardinality();
        return this.complement ? this.domainSize() - bitSetCardinality : bitSetCardinality;
    }

    public boolean contains(int k) {
        return 0 <= k && (this.complement ? k < this.domainSize() && !this.bitmap.contains(k) : this.bitmap.contains(k));
    }

    public boolean containsAll(IntCollection indices) {
        assert (this.checkConsistency());
        if (this.isEmpty()) {
            return indices.isEmpty();
        }
        if (indices.isEmpty()) {
            return true;
        }
        if (indices instanceof RoaringBoundedNatBitSet) {
            RoaringBoundedNatBitSet other = (RoaringBoundedNatBitSet)indices;
            if (this.complement) {
                if (other.complement) {
                    if (other.domainSize() >= this.domainSize()) {
                        return other.bitmap.nextAbsentValue(this.domainSize()) == (long)other.domainSize() && other.bitmap.contains(this.bitmap);
                    }
                    return RoaringBitmap.andCardinality((RoaringBitmap)this.bitmap, (RoaringBitmap)other.bitmap) == this.bitmap.rank(other.domainSize() - 1);
                }
                return other.lastInt() < this.domainSize() && !RoaringBitmap.intersects((RoaringBitmap)this.bitmap, (RoaringBitmap)other.bitmap);
            }
            if (other.complement) {
                if (other.domainSize() >= this.domainSize()) {
                    return this.bitmap.getCardinality() + other.bitmap.getCardinality() == other.domainSize() + RoaringBitmap.andCardinality((RoaringBitmap)this.bitmap, (RoaringBitmap)other.bitmap);
                }
                return this.bitmap.rank(other.domainSize() - 1) + other.bitmap.getCardinality() == other.domainSize() + RoaringBitmap.andCardinality((RoaringBitmap)this.bitmap, (RoaringBitmap)other.bitmap);
            }
            return this.bitmap.contains(other.bitmap);
        }
        if (indices instanceof RoaringNatBitSet) {
            RoaringNatBitSet other = (RoaringNatBitSet)indices;
            if (this.complement) {
                return other.lastInt() < this.domainSize() && !RoaringBitmap.intersects((RoaringBitmap)this.bitmap, (RoaringBitmap)other.bitmap());
            }
            return this.bitmap.contains(other.bitmap());
        }
        return super.containsAll(indices);
    }

    @Override
    public int firstInt() {
        assert (this.checkConsistency());
        if (this.complement) {
            int firstInt = Math.toIntExact(this.bitmap.nextAbsentValue(0));
            if (firstInt >= this.domainSize()) {
                throw new NoSuchElementException();
            }
            return firstInt;
        }
        return this.bitmap.first();
    }

    @Override
    public int lastInt() {
        int lastInt;
        assert (this.checkConsistency());
        if (this.complement) {
            lastInt = Math.toIntExact(this.bitmap.previousAbsentValue(this.domainSize() - 1));
            if (lastInt == -1) {
                throw new NoSuchElementException();
            }
        } else {
            lastInt = this.bitmap.last();
        }
        assert (0 <= lastInt && lastInt < this.domainSize());
        return lastInt;
    }

    @Override
    public int nextPresentIndex(int index) {
        assert (this.checkConsistency());
        NatBitSetsUtil.checkNonNegative(index);
        if (index >= this.domainSize()) {
            return -1;
        }
        if (this.complement) {
            int nextClear = Math.toIntExact(this.bitmap.nextAbsentValue(index));
            return nextClear >= this.domainSize() ? -1 : nextClear;
        }
        return Math.toIntExact(this.bitmap.nextValue(index));
    }

    @Override
    public int nextAbsentIndex(int index) {
        assert (this.checkConsistency());
        NatBitSetsUtil.checkNonNegative(index);
        if (index >= this.domainSize()) {
            return index;
        }
        if (this.complement) {
            int nextSet = Math.toIntExact(this.bitmap.nextValue(index));
            return nextSet == -1 ? this.domainSize() : nextSet;
        }
        return Math.toIntExact(this.bitmap.nextAbsentValue(index));
    }

    @Override
    public int previousPresentIndex(int index) {
        assert (this.checkConsistency());
        NatBitSetsUtil.checkNonNegative(index);
        int clampedIndex = Math.min(index, this.domainSize() - 1);
        return Math.toIntExact(this.complement ? this.bitmap.previousAbsentValue(clampedIndex) : this.bitmap.previousValue(clampedIndex));
    }

    @Override
    public int previousAbsentIndex(int index) {
        assert (this.checkConsistency());
        NatBitSetsUtil.checkNonNegative(index);
        if (index >= this.domainSize()) {
            return index;
        }
        return Math.toIntExact(this.complement ? this.bitmap.previousValue(index) : this.bitmap.previousAbsentValue(index));
    }

    @Override
    public IntIterator iterator() {
        assert (this.checkConsistency());
        return RoaringBitmaps.iterator(this.complement ? this.complementBits() : this.bitmap);
    }

    @Override
    public void set(int index) {
        assert (this.checkConsistency());
        this.checkInDomain(index);
        if (this.complement) {
            this.bitmap.remove(index);
        } else {
            this.bitmap.add(index);
        }
        assert (this.checkConsistency());
    }

    @Override
    public void set(int index, boolean value) {
        assert (this.checkConsistency());
        this.checkInDomain(index);
        if (value == this.complement) {
            this.bitmap.remove(index);
        } else {
            this.bitmap.add(index);
        }
        assert (this.checkConsistency());
    }

    @Override
    public void set(int from, int to) {
        assert (this.checkConsistency());
        this.checkInDomain(from, to);
        if (this.complement) {
            this.bitmap.remove((long)from, (long)to);
        } else {
            this.bitmap.add((long)from, (long)to);
        }
        assert (this.checkConsistency());
    }

    public void clear() {
        assert (this.checkConsistency());
        if (this.complement) {
            this.bitmap.add(0L, (long)this.domainSize());
        } else {
            this.bitmap.clear();
        }
        assert (this.checkConsistency());
    }

    @Override
    public void clear(int index) {
        assert (this.checkConsistency());
        if (index >= this.domainSize()) {
            return;
        }
        if (this.complement) {
            this.bitmap.add(index);
        } else {
            this.bitmap.remove(index);
        }
        assert (this.checkConsistency());
    }

    @Override
    public void clear(int from, int to) {
        assert (this.checkConsistency());
        NatBitSetsUtil.checkRange(from, to);
        int domainSize = this.domainSize();
        if (from >= domainSize) {
            return;
        }
        if (this.complement) {
            this.bitmap.add((long)from, (long)Math.min(to, domainSize));
        } else {
            this.bitmap.remove((long)from, (long)Math.min(to, domainSize));
        }
        assert (this.checkConsistency());
    }

    @Override
    public void flip(int index) {
        assert (this.checkConsistency());
        this.checkInDomain(index);
        this.bitmap.flip(index);
        assert (this.checkConsistency());
    }

    @Override
    public void flip(int from, int to) {
        assert (this.checkConsistency());
        this.checkInDomain(from, to);
        this.bitmap.flip((long)from, (long)to);
        assert (this.checkConsistency());
    }

    @Override
    public boolean intersects(Collection<Integer> indices) {
        if (indices instanceof RoaringBoundedNatBitSet) {
            RoaringBoundedNatBitSet other = (RoaringBoundedNatBitSet)((Object)indices);
            return RoaringBitmap.intersects((RoaringBitmap)(this.complement ? this.complementBits() : this.bitmap), (RoaringBitmap)(other.isComplement() ? other.complementBits() : other.bitmap()));
        }
        if (indices instanceof RoaringNatBitSet) {
            RoaringNatBitSet other = (RoaringNatBitSet)((Object)indices);
            if (this.complement) {
                return other.bitmap().getCardinality() > RoaringBitmap.andCardinality((RoaringBitmap)other.bitmap(), (RoaringBitmap)this.bitmap);
            }
            return RoaringBitmap.intersects((RoaringBitmap)this.bitmap, (RoaringBitmap)other.bitmap());
        }
        return super.intersects(indices);
    }

    @Override
    public void and(IntCollection indices) {
        assert (this.checkConsistency());
        if (indices.isEmpty()) {
            this.clear();
        } else if (indices instanceof RoaringBoundedNatBitSet) {
            RoaringBoundedNatBitSet other = (RoaringBoundedNatBitSet)indices;
            if (other.complement) {
                this.doAndComplement(other.bitmap, other.domainSize());
            } else {
                this.doAnd(other.bitmap);
            }
        } else if (indices instanceof RoaringNatBitSet) {
            RoaringNatBitSet other = (RoaringNatBitSet)indices;
            this.doAnd(other.bitmap());
        } else {
            this.doAnd(RoaringBitmaps.of((IntIterable)indices));
        }
        assert (this.checkConsistency());
    }

    private void doAnd(RoaringBitmap other) {
        int domainSize = this.domainSize();
        if (this.complement) {
            this.bitmap.orNot(other, (long)domainSize);
            this.bitmap.remove((long)domainSize, 0x80000000L);
        } else {
            this.bitmap.and(other);
        }
    }

    private void doAndComplement(RoaringBitmap other, int otherDomainSize) {
        int domainSize = this.domainSize();
        if (this.complement) {
            this.bitmap.or(other);
            this.bitmap.add((long)otherDomainSize, (long)domainSize);
            this.bitmap.remove((long)domainSize, (long)otherDomainSize);
        } else {
            this.bitmap.andNot(other);
            this.bitmap.remove((long)otherDomainSize, (long)domainSize);
        }
    }

    @Override
    public void andNot(IntCollection indices) {
        assert (this.checkConsistency());
        if (this.isEmpty() || indices.isEmpty()) {
            return;
        }
        if (indices instanceof RoaringBoundedNatBitSet) {
            RoaringBoundedNatBitSet other = (RoaringBoundedNatBitSet)indices;
            if (other.complement) {
                this.doAndNotComplement(other.bitmap, other.domainSize());
            } else {
                this.doAndNot(other.bitmap);
            }
        } else if (indices instanceof RoaringNatBitSet) {
            RoaringNatBitSet other = (RoaringNatBitSet)indices;
            this.doAndNot(other.bitmap());
        } else if (this.complement) {
            indices.forEach(index -> {
                if (index < this.domainSize()) {
                    this.bitmap.add(index);
                }
            });
        } else {
            RoaringBitmap toRemove = new RoaringBitmap();
            this.bitmap.forEach(index -> {
                if (indices.contains(index)) {
                    toRemove.add(index);
                }
            });
            this.bitmap.andNot(toRemove);
        }
        assert (this.checkConsistency());
    }

    private void doAndNot(RoaringBitmap other) {
        if (this.complement) {
            this.bitmap.or(other);
            this.bitmap.remove((long)this.domainSize(), 0x80000000L);
        } else {
            this.bitmap.andNot(other);
        }
    }

    private void doAndNotComplement(RoaringBitmap other, int otherDomainSize) {
        int domainSize = this.domainSize();
        if (this.complement) {
            if (otherDomainSize < domainSize) {
                RoaringBitmap tail = RoaringBitmaps.subset(this.bitmap, otherDomainSize, domainSize);
                this.bitmap.orNot(other, (long)otherDomainSize);
                this.bitmap.or(tail);
            } else {
                this.bitmap.orNot(other, (long)domainSize);
                this.bitmap.remove((long)domainSize, 0x80000000L);
            }
        } else if (otherDomainSize < domainSize) {
            RoaringBitmap tail = RoaringBitmaps.subset(this.bitmap, otherDomainSize, domainSize);
            this.bitmap.and(other);
            this.bitmap.or(tail);
        } else {
            this.bitmap.and(other);
        }
    }

    @Override
    public void or(IntCollection indices) {
        assert (this.checkConsistency());
        if (indices.isEmpty()) {
            return;
        }
        if (indices instanceof RoaringBoundedNatBitSet) {
            RoaringBoundedNatBitSet other = (RoaringBoundedNatBitSet)indices;
            this.checkInDomain(other.lastInt());
            if (other.complement) {
                this.doOrComplement(other.bitmap, other.domainSize());
            } else {
                this.doOr(other.bitmap);
            }
        } else if (indices instanceof RoaringNatBitSet) {
            RoaringNatBitSet other = (RoaringNatBitSet)indices;
            this.checkInDomain(other.lastInt());
            this.doOr(other.bitmap());
        } else {
            this.doOr(RoaringBitmaps.of((IntIterable)indices));
        }
        assert (this.checkConsistency());
    }

    private void doOr(RoaringBitmap other) {
        if (this.complement) {
            this.bitmap.andNot(other);
        } else {
            this.bitmap.or(other);
        }
    }

    private void doOrComplement(RoaringBitmap other, int otherDomainSize) {
        if (this.complement) {
            int domainSize = this.domainSize();
            if (otherDomainSize < domainSize) {
                RoaringBitmap tail = RoaringBitmaps.subset(this.bitmap, otherDomainSize, domainSize);
                this.bitmap.and(other);
                this.bitmap.or(tail);
            } else {
                this.bitmap.and(other);
            }
        } else {
            RoaringBitmap tail = RoaringBitmaps.subset(this.bitmap, otherDomainSize, this.domainSize());
            this.bitmap.orNot(other, (long)otherDomainSize);
            this.bitmap.or(tail);
        }
    }

    @Override
    public void orNot(IntCollection indices) {
        assert (this.checkConsistency());
        if (indices.isEmpty()) {
            this.set(0, this.domainSize());
        } else if (indices instanceof RoaringBoundedNatBitSet) {
            RoaringBoundedNatBitSet other = (RoaringBoundedNatBitSet)indices;
            if (other.complement) {
                this.doOrNotComplement(other.bitmap, other.domainSize());
            } else {
                this.doOrNot(other.bitmap);
            }
        } else if (indices instanceof RoaringNatBitSet) {
            this.doOrNot(((RoaringNatBitSet)indices).bitmap());
        } else {
            this.doOrNot(RoaringBitmaps.of((IntIterable)indices));
        }
        assert (this.checkConsistency());
    }

    private void doOrNot(RoaringBitmap other) {
        if (this.complement) {
            this.bitmap.and(other);
        } else {
            int domainSize = this.domainSize();
            this.bitmap.orNot(other, (long)domainSize);
            this.bitmap.remove((long)domainSize, 0x80000000L);
        }
    }

    private void doOrNotComplement(RoaringBitmap other, int otherDomainSize) {
        int domainSize = this.domainSize();
        if (this.complement) {
            this.bitmap.andNot(other);
            if (otherDomainSize < domainSize) {
                this.bitmap.remove((long)otherDomainSize, (long)domainSize);
            }
        } else {
            this.bitmap.or(other);
            if (otherDomainSize < domainSize) {
                this.bitmap.add((long)otherDomainSize, (long)domainSize);
            } else {
                this.bitmap.remove((long)domainSize, (long)otherDomainSize);
            }
        }
    }

    @Override
    public void xor(IntCollection indices) {
        assert (this.checkConsistency());
        if (indices.isEmpty()) {
            return;
        }
        if (indices instanceof RoaringBoundedNatBitSet) {
            RoaringBoundedNatBitSet other = (RoaringBoundedNatBitSet)indices;
            this.checkInDomain(other.lastInt());
            this.bitmap.xor(other.bitmap);
            if (other.complement) {
                this.bitmap.flip(0L, (long)other.domainSize());
            }
        } else if (indices instanceof RoaringNatBitSet) {
            RoaringNatBitSet other = (RoaringNatBitSet)indices;
            this.checkInDomain(other.lastInt());
            this.bitmap.xor(other.bitmap());
        } else {
            this.bitmap.xor(RoaringBitmaps.of((IntIterable)indices));
        }
        assert (this.checkConsistency());
    }

    public boolean removeIf(IntPredicate filter) {
        RoaringBitmap remove = new RoaringBitmap();
        (this.complement ? this.complementBits() : this.bitmap).forEach(i -> {
            if (filter.test(i)) {
                remove.add(i);
            }
        });
        if (this.complement) {
            this.bitmap.or(remove);
        } else {
            this.bitmap.andNot(remove);
        }
        return !remove.isEmpty();
    }

    @Override
    public RoaringBoundedNatBitSet clone() {
        assert (this.checkConsistency());
        return new RoaringBoundedNatBitSet(this.bitmap.clone(), this.domainSize(), this.complement);
    }

    @Override
    public RoaringBoundedNatBitSet complement() {
        return this.complementView;
    }

    public boolean equals(Object o) {
        assert (this.checkConsistency());
        if (this == o) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        if (this.isEmpty()) {
            return ((Collection)o).isEmpty();
        }
        if (((Collection)o).isEmpty()) {
            return false;
        }
        if (o instanceof RoaringBoundedNatBitSet) {
            RoaringBoundedNatBitSet nonComplementSet;
            RoaringBoundedNatBitSet other = (RoaringBoundedNatBitSet)o;
            int domainSize = this.domainSize();
            int otherDomainSize = other.domainSize();
            if (this.complement) {
                if (other.complement) {
                    int largerSize;
                    int smallerSize;
                    RoaringBoundedNatBitSet larger;
                    RoaringBoundedNatBitSet smaller;
                    if (domainSize == otherDomainSize) {
                        return this.bitmap.equals((Object)other.bitmap);
                    }
                    if (domainSize < otherDomainSize) {
                        smaller = this;
                        larger = other;
                        smallerSize = domainSize;
                        largerSize = otherDomainSize;
                    } else {
                        smaller = other;
                        larger = this;
                        smallerSize = otherDomainSize;
                        largerSize = domainSize;
                    }
                    if (larger.bitmap.nextAbsentValue(smallerSize) < (long)largerSize) {
                        return false;
                    }
                    return smaller.bitmap.equals((Object)RoaringBitmaps.subset(larger.bitmap, 0L, smallerSize));
                }
            } else if (!other.complement) {
                return this.bitmap.equals((Object)other.bitmap);
            }
            int complementDomainSize = this.complement ? domainSize : otherDomainSize;
            RoaringBoundedNatBitSet roaringBoundedNatBitSet = nonComplementSet = this.complement ? other : this;
            assert (!nonComplementSet.complement);
            return !RoaringBitmap.intersects((RoaringBitmap)this.bitmap, (RoaringBitmap)other.bitmap) && this.bitmap.getCardinality() + other.bitmap.getCardinality() == complementDomainSize && (domainSize == otherDomainSize || nonComplementSet.lastInt() < complementDomainSize);
        }
        if (o instanceof RoaringNatBitSet) {
            RoaringNatBitSet other = (RoaringNatBitSet)o;
            if (other.lastInt() >= this.domainSize()) {
                return false;
            }
            if (this.isComplement()) {
                return this.size() == other.size() && !RoaringBitmap.intersects((RoaringBitmap)this.bitmap, (RoaringBitmap)other.bitmap());
            }
            return this.bitmap.equals((Object)other.bitmap());
        }
        return super.equals(o);
    }

    RoaringBitmap bitmap() {
        return this.bitmap;
    }

    RoaringBitmap complementBits() {
        return RoaringBitmap.flip((RoaringBitmap)this.bitmap, (long)0L, (long)this.domainSize());
    }

    private boolean checkConsistency() {
        assert (this.bitmap.isEmpty() || this.bitmap.last() < this.domainSize()) : this.bitmap.last() + " " + this.domainSize();
        return true;
    }
}

