/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorTransparent;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentRoseGroupingElse
extends AbstractTextualComponent {
    private final HtmlColor groupBorder;
    private final HtmlColor backgroundColor;

    public ComponentRoseGroupingElse(Style style, HtmlColor groupBorder, FontConfiguration smallFont, CharSequence comment, ISkinSimple spriteContainer, HtmlColor backgroundColor) {
        super(style, LineBreakStrategy.NONE, comment == null ? null : "[" + comment + "]", smallFont, HorizontalAlignment.LEFT, 5, 5, 1, spriteContainer, null, null);
        if (SkinParam.USE_STYLES()) {
            this.groupBorder = style.value(PName.LineColor).asColor(this.getIHtmlColorSet());
            this.backgroundColor = style.value(PName.BackGroundColor).asColor(this.getIHtmlColorSet());
        } else {
            this.groupBorder = groupBorder;
            this.backgroundColor = backgroundColor;
        }
    }

    @Override
    protected void drawBackgroundInternalU(UGraphic ug, Area area) {
        if (this.backgroundColor instanceof HtmlColorTransparent) {
            return;
        }
        Dimension2D dimensionToUse = area.getDimensionToUse();
        URectangle rect = new URectangle(dimensionToUse.getWidth(), dimensionToUse.getHeight());
        ug.apply(new UChangeColor(null)).apply(new UChangeBackColor(this.backgroundColor)).draw(rect);
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        Dimension2D dimensionToUse = area.getDimensionToUse();
        ug = ArrowConfiguration.stroke(ug, 2.0, 2.0, 1.0).apply(new UChangeColor(this.groupBorder));
        ug.apply(new UTranslate(0.0, 1.0)).draw(new ULine(dimensionToUse.getWidth(), 0.0));
        ug = ug.apply(new UStroke());
        this.getTextBlock().drawU(ug.apply(new UTranslate(this.getMarginX1(), this.getMarginY())));
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder);
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder);
    }
}

